/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.LineItemType;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.model.TransactionCreate;
import ch.postfinance.sdk.model.TransactionState;
import java.math.BigDecimal;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TransactionCompletionServiceTest {
    private Long spaceId = 405L;
    private Long applicationUserId = 512L;
    private String authenticationKey = "FKrO76r5VwJtBrqZawBspljbBNOxp5veKQQkOnZxucQ=";
    private ApiClient apiClient;
    private TransactionCreate transactionPayload;

    @Before
    public void setup() {
        if (this.apiClient == null) {
            this.apiClient = new ApiClient(this.applicationUserId.longValue(), this.authenticationKey);
        }
    }

    private TransactionCreate getTransactionPayload() {
        if (this.transactionPayload == null) {
            LineItemCreate lineItem = new LineItemCreate();
            lineItem.name("Red T-Shirt").uniqueId("5412").type(LineItemType.PRODUCT).quantity(BigDecimal.valueOf(1L)).amountIncludingTax(BigDecimal.valueOf(29.95)).sku("red-t-shirt-123");
            AddressCreate billingAddress = new AddressCreate();
            billingAddress.city("Winterthur").country("CH").emailAddress("test@example.com").familyName("Customer").givenName("Good").postcode("8400").postalState("ZH").organizationName("Test GmbH").mobilePhoneNumber("+41791234567").salutation("Ms");
            this.transactionPayload = new TransactionCreate();
            this.transactionPayload.autoConfirmationEnabled(Boolean.valueOf(true)).currency("CHF").language("en-US");
            this.transactionPayload.setBillingAddress(billingAddress);
            this.transactionPayload.setShippingAddress(billingAddress);
            this.transactionPayload.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_DEFERRED);
            this.transactionPayload.addLineItemsItem(lineItem);
        }
        return this.transactionPayload;
    }

    @Test
    public void completeOfflineTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        for (int i = 1; i <= 10 && transaction.getState() != TransactionState.AUTHORIZED && transaction.getState() != TransactionState.FAILED; ++i) {
            try {
                Thread.sleep(i * 500);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            transaction = this.apiClient.getTransactionService().read(this.spaceId, transaction.getId());
        }
        Assert.assertEquals((Object)TransactionState.AUTHORIZED, (Object)transaction.getState());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        TransactionCompletion transactionCompletion = this.apiClient.getTransactionCompletionService().completeOffline(this.spaceId, transaction.getId());
        TransactionCompletionState[] TransactionCompletionStates = new TransactionCompletionState[]{TransactionCompletionState.SUCCESSFUL, TransactionCompletionState.PENDING};
        Assert.assertTrue((String)("Transaction Completions " + transactionCompletion.getState()), (boolean)Arrays.asList(TransactionCompletionStates).contains(transactionCompletion.getState()));
    }

    @Test
    public void completeOnlineTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        for (int i = 1; i <= 10 && transaction.getState() != TransactionState.AUTHORIZED && transaction.getState() != TransactionState.FAILED; ++i) {
            try {
                Thread.sleep(i * 500);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            transaction = this.apiClient.getTransactionService().read(this.spaceId, transaction.getId());
        }
        Assert.assertEquals((Object)TransactionState.AUTHORIZED, (Object)transaction.getState());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        TransactionCompletion transactionCompletion = this.apiClient.getTransactionCompletionService().completeOnline(this.spaceId, transaction.getId());
        TransactionCompletionState[] TransactionCompletionStates = new TransactionCompletionState[]{TransactionCompletionState.SUCCESSFUL, TransactionCompletionState.PENDING};
        Assert.assertTrue((String)("Transaction Completions " + transactionCompletion.getState()), (boolean)Arrays.asList(TransactionCompletionStates).contains(transactionCompletion.getState()));
    }

    @Ignore
    @Test
    public void completePartiallyOfflineTest() {
    }

    @Ignore
    @Test
    public void completePartiallyOnlineTest() {
    }

    @Ignore
    @Test
    public void countTest() {
    }

    @Ignore
    @Test
    public void readTest() {
    }

    @Ignore
    @Test
    public void searchTest() {
    }
}

