/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.UserSpaceRole;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class UserSpaceRoleService {
    private ApiClient apiClient;

    public UserSpaceRoleService(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserSpaceRole addRole(Long userId, Long spaceId, Long roleId) throws IOException {
        HttpResponse response = this.addRoleForHttpResponse(userId, spaceId, roleId);
        String returnType = "UserSpaceRole";
        if (returnType.equals("String")) {
            return (UserSpaceRole)((Object)response.parseAsString());
        }
        TypeReference<UserSpaceRole> typeRef = new TypeReference<UserSpaceRole>(){};
        return (UserSpaceRole)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public UserSpaceRole addRole(Long userId, Long spaceId, Long roleId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.addRoleForHttpResponse(userId, spaceId, roleId, params);
        String returnType = "UserSpaceRole";
        if (returnType.equals("String")) {
            return (UserSpaceRole)((Object)response.parseAsString());
        }
        TypeReference<UserSpaceRole> typeRef = new TypeReference<UserSpaceRole>(){};
        return (UserSpaceRole)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse addRoleForHttpResponse(Long userId, Long spaceId, Long roleId) throws IOException {
        Long value;
        String key;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling addRole");
        }
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling addRole");
        }
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling addRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/addRole"));
        if (userId != null) {
            key = "userId";
            value = userId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (roleId != null) {
            key = "roleId";
            value = roleId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse addRoleForHttpResponse(Long userId, Long spaceId, Long roleId, Map<String, Object> params) throws IOException {
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling addRole");
        }
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling addRole");
        }
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling addRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/addRole"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("userId", userId);
        allParams.put("spaceId", spaceId);
        allParams.put("roleId", roleId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<UserSpaceRole> list(Long userId, Long spaceId) throws IOException {
        HttpResponse response = this.listForHttpResponse(userId, spaceId);
        String returnType = "List&lt;UserSpaceRole&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<UserSpaceRole>> typeRef = new TypeReference<List<UserSpaceRole>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<UserSpaceRole> list(Long userId, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.listForHttpResponse(userId, spaceId, params);
        String returnType = "List&lt;UserSpaceRole&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<UserSpaceRole>> typeRef = new TypeReference<List<UserSpaceRole>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse listForHttpResponse(Long userId, Long spaceId) throws IOException {
        Long value;
        String key;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling list");
        }
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling list");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/list"));
        if (userId != null) {
            key = "userId";
            value = userId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse listForHttpResponse(Long userId, Long spaceId, Map<String, Object> params) throws IOException {
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling list");
        }
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling list");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/list"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("userId", userId);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void removeRole(Long id) throws IOException {
        this.removeRoleForHttpResponse(id);
    }

    public void removeRole(Long id, Map<String, Object> params) throws IOException {
        this.removeRoleForHttpResponse(id, params);
    }

    public HttpResponse removeRoleForHttpResponse(Long id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling removeRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/removeRole"));
        if (id != null) {
            String key = "id";
            Long value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse removeRoleForHttpResponse(Long id, Map<String, Object> params) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling removeRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-space-role/removeRole"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }
}

