/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class TransactionCompletionService {
    private ApiClient apiClient;

    public TransactionCompletionService(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TransactionCompletion completeOffline(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.completeOfflineForHttpResponse(spaceId, id);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TransactionCompletion completeOffline(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.completeOfflineForHttpResponse(spaceId, id, params);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse completeOfflineForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completeOffline");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling completeOffline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completeOffline"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completeOfflineForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completeOffline");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling completeOffline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completeOffline"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public TransactionCompletion completeOnline(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.completeOnlineForHttpResponse(spaceId, id);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TransactionCompletion completeOnline(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.completeOnlineForHttpResponse(spaceId, id, params);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse completeOnlineForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completeOnline");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling completeOnline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completeOnline"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completeOnlineForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completeOnline");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling completeOnline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completeOnline"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public TransactionCompletion completePartiallyOffline(Long spaceId, TransactionCompletionRequest completion) throws IOException {
        HttpResponse response = this.completePartiallyOfflineForHttpResponse(spaceId, completion);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TransactionCompletion completePartiallyOffline(Long spaceId, TransactionCompletionRequest completion, Map<String, Object> params) throws IOException {
        HttpResponse response = this.completePartiallyOfflineForHttpResponse(spaceId, completion, params);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse completePartiallyOfflineForHttpResponse(Long spaceId, TransactionCompletionRequest completion) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOffline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOffline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOffline"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, completion);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completePartiallyOfflineForHttpResponse(Long spaceId, InputStream completion, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOffline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOffline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOffline"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (completion == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, completion);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completePartiallyOfflineForHttpResponse(Long spaceId, TransactionCompletionRequest completion, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOffline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOffline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOffline"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, completion);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public TransactionCompletion completePartiallyOnline(Long spaceId, TransactionCompletionRequest completion) throws IOException {
        HttpResponse response = this.completePartiallyOnlineForHttpResponse(spaceId, completion);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TransactionCompletion completePartiallyOnline(Long spaceId, TransactionCompletionRequest completion, Map<String, Object> params) throws IOException {
        HttpResponse response = this.completePartiallyOnlineForHttpResponse(spaceId, completion, params);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse completePartiallyOnlineForHttpResponse(Long spaceId, TransactionCompletionRequest completion) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOnline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOnline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOnline"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, completion);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completePartiallyOnlineForHttpResponse(Long spaceId, InputStream completion, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOnline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOnline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOnline"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (completion == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, completion);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse completePartiallyOnlineForHttpResponse(Long spaceId, TransactionCompletionRequest completion, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling completePartiallyOnline");
        }
        if (completion == null) {
            throw new IllegalArgumentException("Missing the required parameter 'completion' when calling completePartiallyOnline");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/completePartiallyOnline"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, completion);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Long count(Long spaceId, EntityQueryFilter filter) throws IOException {
        HttpResponse response = this.countForHttpResponse(spaceId, filter);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Long count(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.countForHttpResponse(filter, spaceId, params);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse countForHttpResponse(Long spaceId, EntityQueryFilter filter) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(Long spaceId, InputStream filter, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (filter == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, filter);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/count"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public TransactionCompletion read(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TransactionCompletion read(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id, params);
        String returnType = "TransactionCompletion";
        if (returnType.equals("String")) {
            return (TransactionCompletion)((Object)response.parseAsString());
        }
        TypeReference<TransactionCompletion> typeRef = new TypeReference<TransactionCompletion>(){};
        return (TransactionCompletion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/read"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/read"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<TransactionCompletion> search(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query);
        String returnType = "List&lt;TransactionCompletion&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<TransactionCompletion>> typeRef = new TypeReference<List<TransactionCompletion>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<TransactionCompletion> search(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;TransactionCompletion&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<TransactionCompletion>> typeRef = new TypeReference<List<TransactionCompletion>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/transaction-completion/search"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }
}

