/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.Charge;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.Token;
import ch.postfinance.sdk.model.TokenCreate;
import ch.postfinance.sdk.model.TokenUpdate;
import ch.postfinance.sdk.model.TokenVersion;
import ch.postfinance.sdk.model.Transaction;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class TokenService {
    private ApiClient apiClient;

    public TokenService(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Boolean checkTokenCreationPossible(Long spaceId, Long transactionId) throws IOException {
        HttpResponse response = this.checkTokenCreationPossibleForHttpResponse(spaceId, transactionId);
        String returnType = "Boolean";
        if (returnType.equals("String")) {
            return (Boolean)((Object)response.parseAsString());
        }
        TypeReference<Boolean> typeRef = new TypeReference<Boolean>(){};
        return (Boolean)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Boolean checkTokenCreationPossible(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.checkTokenCreationPossibleForHttpResponse(spaceId, transactionId, params);
        String returnType = "Boolean";
        if (returnType.equals("String")) {
            return (Boolean)((Object)response.parseAsString());
        }
        TypeReference<Boolean> typeRef = new TypeReference<Boolean>(){};
        return (Boolean)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse checkTokenCreationPossibleForHttpResponse(Long spaceId, Long transactionId) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling checkTokenCreationPossible");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling checkTokenCreationPossible");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/check-token-creation-possible"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse checkTokenCreationPossibleForHttpResponse(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling checkTokenCreationPossible");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling checkTokenCreationPossible");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/check-token-creation-possible"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Long count(Long spaceId, EntityQueryFilter filter) throws IOException {
        HttpResponse response = this.countForHttpResponse(spaceId, filter);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Long count(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.countForHttpResponse(filter, spaceId, params);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse countForHttpResponse(Long spaceId, EntityQueryFilter filter) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(Long spaceId, InputStream filter, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (filter == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, filter);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/count"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Token create(Long spaceId, TokenCreate entity) throws IOException {
        HttpResponse response = this.createForHttpResponse(spaceId, entity);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Token create(Long spaceId, TokenCreate entity, Map<String, Object> params) throws IOException {
        HttpResponse response = this.createForHttpResponse(spaceId, entity, params);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse createForHttpResponse(Long spaceId, TokenCreate entity) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling create");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/create"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, entity);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse createForHttpResponse(Long spaceId, InputStream entity, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling create");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/create"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (entity == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, entity);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse createForHttpResponse(Long spaceId, TokenCreate entity, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling create");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/create"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, entity);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public TokenVersion createTokenBasedOnTransaction(Long spaceId, Long transactionId) throws IOException {
        HttpResponse response = this.createTokenBasedOnTransactionForHttpResponse(spaceId, transactionId);
        String returnType = "TokenVersion";
        if (returnType.equals("String")) {
            return (TokenVersion)((Object)response.parseAsString());
        }
        TypeReference<TokenVersion> typeRef = new TypeReference<TokenVersion>(){};
        return (TokenVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public TokenVersion createTokenBasedOnTransaction(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.createTokenBasedOnTransactionForHttpResponse(spaceId, transactionId, params);
        String returnType = "TokenVersion";
        if (returnType.equals("String")) {
            return (TokenVersion)((Object)response.parseAsString());
        }
        TypeReference<TokenVersion> typeRef = new TypeReference<TokenVersion>(){};
        return (TokenVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse createTokenBasedOnTransactionForHttpResponse(Long spaceId, Long transactionId) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling createTokenBasedOnTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling createTokenBasedOnTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/create-token-based-on-transaction"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse createTokenBasedOnTransactionForHttpResponse(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling createTokenBasedOnTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling createTokenBasedOnTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/create-token-based-on-transaction"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Transaction createTransactionForTokenUpdate(Long spaceId, Long tokenId) throws IOException {
        HttpResponse response = this.createTransactionForTokenUpdateForHttpResponse(spaceId, tokenId);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Transaction createTransactionForTokenUpdate(Long spaceId, Long tokenId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.createTransactionForTokenUpdateForHttpResponse(spaceId, tokenId, params);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse createTransactionForTokenUpdateForHttpResponse(Long spaceId, Long tokenId) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling createTransactionForTokenUpdate");
        }
        if (tokenId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'tokenId' when calling createTransactionForTokenUpdate");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/createTransactionForTokenUpdate"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (tokenId != null) {
            key = "tokenId";
            value = tokenId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse createTransactionForTokenUpdateForHttpResponse(Long spaceId, Long tokenId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling createTransactionForTokenUpdate");
        }
        if (tokenId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'tokenId' when calling createTransactionForTokenUpdate");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/createTransactionForTokenUpdate"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("tokenId", tokenId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void delete(Long spaceId, Long id) throws IOException {
        this.deleteForHttpResponse(spaceId, id);
    }

    public void delete(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        this.deleteForHttpResponse(spaceId, id, params);
    }

    public HttpResponse deleteForHttpResponse(Long spaceId, Long id) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling delete");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling delete");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/delete"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, id);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse deleteForHttpResponse(Long spaceId, InputStream id, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling delete");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling delete");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/delete"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (id == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, id);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse deleteForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling delete");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling delete");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/delete"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, id);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Charge processTransaction(Long spaceId, Long transactionId) throws IOException {
        HttpResponse response = this.processTransactionForHttpResponse(spaceId, transactionId);
        String returnType = "Charge";
        if (returnType.equals("String")) {
            return (Charge)((Object)response.parseAsString());
        }
        TypeReference<Charge> typeRef = new TypeReference<Charge>(){};
        return (Charge)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Charge processTransaction(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.processTransactionForHttpResponse(spaceId, transactionId, params);
        String returnType = "Charge";
        if (returnType.equals("String")) {
            return (Charge)((Object)response.parseAsString());
        }
        TypeReference<Charge> typeRef = new TypeReference<Charge>(){};
        return (Charge)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse processTransactionForHttpResponse(Long spaceId, Long transactionId) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling processTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling processTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/process-transaction"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse processTransactionForHttpResponse(Long spaceId, Long transactionId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling processTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling processTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/process-transaction"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Token read(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Token read(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id, params);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/read"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/read"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<Token> search(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query);
        String returnType = "List&lt;Token&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<Token>> typeRef = new TypeReference<List<Token>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<Token> search(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;Token&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<Token>> typeRef = new TypeReference<List<Token>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/search"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public Token update(Long spaceId, TokenUpdate entity) throws IOException {
        HttpResponse response = this.updateForHttpResponse(spaceId, entity);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Token update(Long spaceId, TokenUpdate entity, Map<String, Object> params) throws IOException {
        HttpResponse response = this.updateForHttpResponse(spaceId, entity, params);
        String returnType = "Token";
        if (returnType.equals("String")) {
            return (Token)((Object)response.parseAsString());
        }
        TypeReference<Token> typeRef = new TypeReference<Token>(){};
        return (Token)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse updateForHttpResponse(Long spaceId, TokenUpdate entity) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling update");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/update"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, entity);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse updateForHttpResponse(Long spaceId, InputStream entity, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling update");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/update"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (entity == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, entity);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse updateForHttpResponse(Long spaceId, TokenUpdate entity, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Missing the required parameter 'entity' when calling update");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/token/update"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, entity);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }
}

