/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.WebhookIdentity;
import ch.postfinance.sdk.model.WebhookUrl;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class WebhookListener {
    @JsonProperty(value="entity")
    protected Long entity = null;
    @JsonProperty(value="entityStates")
    protected List<String> entityStates = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="identity")
    protected WebhookIdentity identity = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="notifyEveryChange")
    protected Boolean notifyEveryChange = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="url")
    protected WebhookUrl url = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The listener listens on state changes of the entity linked with the listener.")
    public Long getEntity() {
        return this.entity;
    }

    @ApiModelProperty(value="The target state identifies the state into which entities need to move into to trigger the webhook listener.")
    public List<String> getEntityStates() {
        return this.entityStates;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The identity which will be used to sign messages sent by this listener.")
    public WebhookIdentity getIdentity() {
        return this.identity;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The webhook listener name is used internally to identify the webhook listener in administrative interfaces.For example it is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Defines whether the webhook listener is to be informed about every change made to the entity in contrast to state transitions only.")
    public Boolean isNotifyEveryChange() {
        return this.notifyEveryChange;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The URL which is invoked by the listener to notify the application about the event.")
    public WebhookUrl getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookListener webhookListener = (WebhookListener)o;
        return Objects.equals(this.entity, webhookListener.entity) && Objects.equals(this.entityStates, webhookListener.entityStates) && Objects.equals(this.id, webhookListener.id) && Objects.equals(this.identity, webhookListener.identity) && Objects.equals(this.linkedSpaceId, webhookListener.linkedSpaceId) && Objects.equals(this.name, webhookListener.name) && Objects.equals(this.notifyEveryChange, webhookListener.notifyEveryChange) && Objects.equals(this.plannedPurgeDate, webhookListener.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)webhookListener.state) && Objects.equals(this.url, webhookListener.url) && Objects.equals(this.version, webhookListener.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.entityStates, this.id, this.identity, this.linkedSpaceId, this.name, this.notifyEveryChange, this.plannedPurgeDate, this.state, this.url, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookListener {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityStates: ").append(this.toIndentedString(this.entityStates)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifyEveryChange: ").append(this.toIndentedString(this.notifyEveryChange)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

