/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.LineItemCreate;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class TransactionInvoiceReplacement {
    @JsonProperty(value="billingAddress")
    protected AddressCreate billingAddress = null;
    @JsonProperty(value="dueOn")
    protected OffsetDateTime dueOn = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="lineItems")
    protected List<LineItemCreate> lineItems = new ArrayList<LineItemCreate>();
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="sentToCustomer")
    protected Boolean sentToCustomer = null;

    public TransactionInvoiceReplacement billingAddress(AddressCreate billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public AddressCreate getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressCreate billingAddress) {
        this.billingAddress = billingAddress;
    }

    public TransactionInvoiceReplacement dueOn(OffsetDateTime dueOn) {
        this.dueOn = dueOn;
        return this;
    }

    @ApiModelProperty(value="The date on which the invoice should be paid on.")
    public OffsetDateTime getDueOn() {
        return this.dueOn;
    }

    public void setDueOn(OffsetDateTime dueOn) {
        this.dueOn = dueOn;
    }

    public TransactionInvoiceReplacement externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(required=true, value="The external id helps to identify the entity and a subsequent creation of an entity with the same ID will not create a new entity.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public TransactionInvoiceReplacement lineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public TransactionInvoiceReplacement addLineItemsItem(LineItemCreate lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<LineItemCreate> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
    }

    public TransactionInvoiceReplacement merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public TransactionInvoiceReplacement sentToCustomer(Boolean sentToCustomer) {
        this.sentToCustomer = sentToCustomer;
        return this;
    }

    @ApiModelProperty(value="When the connector is configured to send the invoice to the customer and this property is true the customer will receive an email with the updated invoice. When this property is false no invoice is sent.")
    public Boolean isSentToCustomer() {
        return this.sentToCustomer;
    }

    public void setSentToCustomer(Boolean sentToCustomer) {
        this.sentToCustomer = sentToCustomer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInvoiceReplacement transactionInvoiceReplacement = (TransactionInvoiceReplacement)o;
        return Objects.equals(this.billingAddress, transactionInvoiceReplacement.billingAddress) && Objects.equals(this.dueOn, transactionInvoiceReplacement.dueOn) && Objects.equals(this.externalId, transactionInvoiceReplacement.externalId) && Objects.equals(this.lineItems, transactionInvoiceReplacement.lineItems) && Objects.equals(this.merchantReference, transactionInvoiceReplacement.merchantReference) && Objects.equals(this.sentToCustomer, transactionInvoiceReplacement.sentToCustomer);
    }

    public int hashCode() {
        return Objects.hash(this.billingAddress, this.dueOn, this.externalId, this.lineItems, this.merchantReference, this.sentToCustomer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionInvoiceReplacement {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    dueOn: ").append(this.toIndentedString(this.dueOn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    sentToCustomer: ").append(this.toIndentedString(this.sentToCustomer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

