/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CompletionLineItemCreate;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class TransactionCompletionRequest {
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="invoiceMerchantReference")
    protected String invoiceMerchantReference = null;
    @JsonProperty(value="lastCompletion")
    protected Boolean lastCompletion = null;
    @JsonProperty(value="lineItems")
    protected List<CompletionLineItemCreate> lineItems = null;
    @JsonProperty(value="statementDescriptor")
    protected String statementDescriptor = null;
    @JsonProperty(value="transactionId")
    protected Long transactionId = null;

    public TransactionCompletionRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(required=true, value="The external ID helps to identify the entity and a subsequent creation of an entity with the same ID will not create a new entity.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public TransactionCompletionRequest invoiceMerchantReference(String invoiceMerchantReference) {
        this.invoiceMerchantReference = invoiceMerchantReference;
        return this;
    }

    @ApiModelProperty(value="")
    public String getInvoiceMerchantReference() {
        return this.invoiceMerchantReference;
    }

    public void setInvoiceMerchantReference(String invoiceMerchantReference) {
        this.invoiceMerchantReference = invoiceMerchantReference;
    }

    public TransactionCompletionRequest lastCompletion(Boolean lastCompletion) {
        this.lastCompletion = lastCompletion;
        return this;
    }

    @ApiModelProperty(required=true, value="The last completion flag indicates if this is the last completion. After the last completion is created no further completions can be issued.")
    public Boolean isLastCompletion() {
        return this.lastCompletion;
    }

    public void setLastCompletion(Boolean lastCompletion) {
        this.lastCompletion = lastCompletion;
    }

    public TransactionCompletionRequest lineItems(List<CompletionLineItemCreate> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public TransactionCompletionRequest addLineItemsItem(CompletionLineItemCreate lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<CompletionLineItemCreate>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="The line items which will be used to complete the transaction.")
    public List<CompletionLineItemCreate> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<CompletionLineItemCreate> lineItems) {
        this.lineItems = lineItems;
    }

    public TransactionCompletionRequest statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @ApiModelProperty(value="The statement descriptor explain charges or payments on bank statements.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public TransactionCompletionRequest transactionId(Long transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the transaction which should be completed.")
    public Long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionCompletionRequest transactionCompletionRequest = (TransactionCompletionRequest)o;
        return Objects.equals(this.externalId, transactionCompletionRequest.externalId) && Objects.equals(this.invoiceMerchantReference, transactionCompletionRequest.invoiceMerchantReference) && Objects.equals(this.lastCompletion, transactionCompletionRequest.lastCompletion) && Objects.equals(this.lineItems, transactionCompletionRequest.lineItems) && Objects.equals(this.statementDescriptor, transactionCompletionRequest.statementDescriptor) && Objects.equals(this.transactionId, transactionCompletionRequest.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.externalId, this.invoiceMerchantReference, this.lastCompletion, this.lineItems, this.statementDescriptor, this.transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionCompletionRequest {\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    invoiceMerchantReference: ").append(this.toIndentedString(this.invoiceMerchantReference)).append("\n");
        sb.append("    lastCompletion: ").append(this.toIndentedString(this.lastCompletion)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

