/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class Token {
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="customerEmailAddress")
    protected String customerEmailAddress = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="enabledForOneClickPayment")
    protected Boolean enabledForOneClickPayment = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="tokenReference")
    protected String tokenReference = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The customer email address is the email address of the customer.")
    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    @ApiModelProperty(value="The customer ID identifies the customer in the merchant system. In case the customer ID has been provided it has to correspond with the customer ID provided on the transaction. The customer ID will not be changed automatically. The merchant system has to provide it.")
    public String getCustomerId() {
        return this.customerId;
    }

    @ApiModelProperty(value="When a token is enabled for one-click payments the buyer will be able to select the token within the iFrame or on the payment page to pay with the token. The usage of the token will reduce the number of steps the buyer has to go through. The buyer is linked via the customer ID on the transaction with the token. Means the token will be visible for buyers with the same customer ID. Additionally the payment method has to be configured to allow the one-click payments.")
    public Boolean isEnabledForOneClickPayment() {
        return this.enabledForOneClickPayment;
    }

    @ApiModelProperty(value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The time zone defines in which time zone the customer is located in. The time zone may affects how dates are formatted when interacting with the customer.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="Use something that it is easy to identify and may help you find the token (e.g. customer id, email address).")
    public String getTokenReference() {
        return this.tokenReference;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.createdOn, token.createdOn) && Objects.equals(this.customerEmailAddress, token.customerEmailAddress) && Objects.equals(this.customerId, token.customerId) && Objects.equals(this.enabledForOneClickPayment, token.enabledForOneClickPayment) && Objects.equals(this.externalId, token.externalId) && Objects.equals(this.id, token.id) && Objects.equals(this.language, token.language) && Objects.equals(this.linkedSpaceId, token.linkedSpaceId) && Objects.equals(this.plannedPurgeDate, token.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)token.state) && Objects.equals(this.timeZone, token.timeZone) && Objects.equals(this.tokenReference, token.tokenReference) && Objects.equals(this.version, token.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdOn, this.customerEmailAddress, this.customerId, this.enabledForOneClickPayment, this.externalId, this.id, this.language, this.linkedSpaceId, this.plannedPurgeDate, this.state, this.timeZone, this.tokenReference, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Token {\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    enabledForOneClickPayment: ").append(this.toIndentedString(this.enabledForOneClickPayment)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    tokenReference: ").append(this.toIndentedString(this.tokenReference)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

