/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class RestLanguage {
    @JsonProperty(value="countryCode")
    protected String countryCode = null;
    @JsonProperty(value="ietfCode")
    protected String ietfCode = null;
    @JsonProperty(value="iso2Code")
    protected String iso2Code = null;
    @JsonProperty(value="iso3Code")
    protected String iso3Code = null;
    @JsonProperty(value="pluralExpression")
    protected String pluralExpression = null;
    @JsonProperty(value="primaryOfGroup")
    protected Boolean primaryOfGroup = null;

    @ApiModelProperty(value="The country code represents the region of the language as a 2 letter ISO code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    @ApiModelProperty(value="The IETF code represents the language as the two letter ISO code including the region (e.g. en-US).")
    public String getIetfCode() {
        return this.ietfCode;
    }

    @ApiModelProperty(value="The ISO 2 letter code represents the language with two letters.")
    public String getIso2Code() {
        return this.iso2Code;
    }

    @ApiModelProperty(value="The ISO 3 letter code represents the language with three letters.")
    public String getIso3Code() {
        return this.iso3Code;
    }

    @ApiModelProperty(value="The plural expression defines how to map a plural into the language index. This expression is used to determine the plural form for the translations.")
    public String getPluralExpression() {
        return this.pluralExpression;
    }

    @ApiModelProperty(value="The primary language of a group indicates whether a language is the primary language of a group of languages. The group is determine by the ISO 2 letter code.")
    public Boolean isPrimaryOfGroup() {
        return this.primaryOfGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestLanguage restLanguage = (RestLanguage)o;
        return Objects.equals(this.countryCode, restLanguage.countryCode) && Objects.equals(this.ietfCode, restLanguage.ietfCode) && Objects.equals(this.iso2Code, restLanguage.iso2Code) && Objects.equals(this.iso3Code, restLanguage.iso3Code) && Objects.equals(this.pluralExpression, restLanguage.pluralExpression) && Objects.equals(this.primaryOfGroup, restLanguage.primaryOfGroup);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.ietfCode, this.iso2Code, this.iso3Code, this.pluralExpression, this.primaryOfGroup);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestLanguage {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    ietfCode: ").append(this.toIndentedString(this.ietfCode)).append("\n");
        sb.append("    iso2Code: ").append(this.toIndentedString(this.iso2Code)).append("\n");
        sb.append("    iso3Code: ").append(this.toIndentedString(this.iso3Code)).append("\n");
        sb.append("    pluralExpression: ").append(this.toIndentedString(this.pluralExpression)).append("\n");
        sb.append("    primaryOfGroup: ").append(this.toIndentedString(this.primaryOfGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

