/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.LineItemReductionCreate;
import ch.postfinance.sdk.model.RefundType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The refund represents a credit back to the customer. It can be issued by the merchant or by the customer (reversal).")
public class RefundCreate {
    @JsonProperty(value="amount")
    protected BigDecimal amount = null;
    @JsonProperty(value="completion")
    protected Long completion = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="reductions")
    protected List<LineItemReductionCreate> reductions = null;
    @JsonProperty(value="transaction")
    protected Long transaction = null;
    @JsonProperty(value="type")
    protected RefundType type = null;

    public RefundCreate amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public RefundCreate completion(Long completion) {
        this.completion = completion;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getCompletion() {
        return this.completion;
    }

    public void setCompletion(Long completion) {
        this.completion = completion;
    }

    public RefundCreate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(required=true, value="The external id helps to identify duplicate calls to the refund service. As such the external ID has to be unique per transaction.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public RefundCreate merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public RefundCreate reductions(List<LineItemReductionCreate> reductions) {
        this.reductions = reductions;
        return this;
    }

    public RefundCreate addReductionsItem(LineItemReductionCreate reductionsItem) {
        if (this.reductions == null) {
            this.reductions = new ArrayList<LineItemReductionCreate>();
        }
        this.reductions.add(reductionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LineItemReductionCreate> getReductions() {
        return this.reductions;
    }

    public void setReductions(List<LineItemReductionCreate> reductions) {
        this.reductions = reductions;
    }

    public RefundCreate transaction(Long transaction) {
        this.transaction = transaction;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Long transaction) {
        this.transaction = transaction;
    }

    public RefundCreate type(RefundType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RefundType getType() {
        return this.type;
    }

    public void setType(RefundType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundCreate refundCreate = (RefundCreate)o;
        return Objects.equals(this.amount, refundCreate.amount) && Objects.equals(this.completion, refundCreate.completion) && Objects.equals(this.externalId, refundCreate.externalId) && Objects.equals(this.merchantReference, refundCreate.merchantReference) && Objects.equals(this.reductions, refundCreate.reductions) && Objects.equals(this.transaction, refundCreate.transaction) && Objects.equals((Object)this.type, (Object)refundCreate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.completion, this.externalId, this.merchantReference, this.reductions, this.transaction, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundCreate {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    completion: ").append(this.toIndentedString(this.completion)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    reductions: ").append(this.toIndentedString(this.reductions)).append("\n");
        sb.append("    transaction: ").append(this.toIndentedString(this.transaction)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

