/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CriteriaOperator;
import ch.postfinance.sdk.model.EntityQueryFilterType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The query filter allows to restrict the entities which are returned.")
public class EntityQueryFilter {
    @JsonProperty(value="children")
    protected List<EntityQueryFilter> children = null;
    @JsonProperty(value="fieldName")
    protected String fieldName = null;
    @JsonProperty(value="operator")
    protected CriteriaOperator operator = null;
    @JsonProperty(value="type")
    protected EntityQueryFilterType type = null;
    @JsonProperty(value="value")
    protected Object value = null;

    public EntityQueryFilter children(List<EntityQueryFilter> children) {
        this.children = children;
        return this;
    }

    public EntityQueryFilter addChildrenItem(EntityQueryFilter childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityQueryFilter>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @ApiModelProperty(value="The 'children' can contain other filter nodes which are applied to the query. This property is only applicable on filter types 'OR' and 'AND'.")
    public List<EntityQueryFilter> getChildren() {
        return this.children;
    }

    public void setChildren(List<EntityQueryFilter> children) {
        this.children = children;
    }

    public EntityQueryFilter fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @ApiModelProperty(value="The 'fieldName' indicates the property on the entity which should be filtered. This property is only applicable on filter type 'LEAF'.")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public EntityQueryFilter operator(CriteriaOperator operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(value="The 'operator' indicates what kind of filtering on the 'fieldName' is executed on. This property is only applicable on filter type 'LEAF'.")
    public CriteriaOperator getOperator() {
        return this.operator;
    }

    public void setOperator(CriteriaOperator operator) {
        this.operator = operator;
    }

    public EntityQueryFilter type(EntityQueryFilterType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The filter type controls how the query node is interpreted. I.e. if the node acts as leaf node or as a filter group.")
    public EntityQueryFilterType getType() {
        return this.type;
    }

    public void setType(EntityQueryFilterType type) {
        this.type = type;
    }

    public EntityQueryFilter value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The 'value' is used to compare with the 'fieldName' as defined by the 'operator'. This property is only applicable on filter type 'LEAF'.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityQueryFilter entityQueryFilter = (EntityQueryFilter)o;
        return Objects.equals(this.children, entityQueryFilter.children) && Objects.equals(this.fieldName, entityQueryFilter.fieldName) && Objects.equals((Object)this.operator, (Object)entityQueryFilter.operator) && Objects.equals((Object)this.type, (Object)entityQueryFilter.type) && Objects.equals(this.value, entityQueryFilter.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.children, this.fieldName, this.operator, this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityQueryFilter {\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

