/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.ChargeFlow;
import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class ChargeFlowLevelConfiguration {
    @JsonProperty(value="flow")
    protected ChargeFlow flow = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="period")
    protected String period = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="priority")
    protected Integer priority = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="type")
    protected Long type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The charge flow level configuration to which the flow is associated.")
    public ChargeFlow getFlow() {
        return this.flow;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The charge flow level configuration name is used internally to identify the charge flow level configuration. For example the name is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The duration of the level before switching to the next one.")
    public String getPeriod() {
        return this.period;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The priority indicates the sort order of the level configurations. A low value indicates that the level configuration is executed before any level with a higher value. Any change to this value affects future level configuration selections.")
    public Integer getPriority() {
        return this.priority;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The type determines how the payment link is delivered to the customer. Once the type is defined it cannot be changed anymore.")
    public Long getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeFlowLevelConfiguration chargeFlowLevelConfiguration = (ChargeFlowLevelConfiguration)o;
        return Objects.equals(this.flow, chargeFlowLevelConfiguration.flow) && Objects.equals(this.id, chargeFlowLevelConfiguration.id) && Objects.equals(this.linkedSpaceId, chargeFlowLevelConfiguration.linkedSpaceId) && Objects.equals(this.name, chargeFlowLevelConfiguration.name) && Objects.equals(this.period, chargeFlowLevelConfiguration.period) && Objects.equals(this.plannedPurgeDate, chargeFlowLevelConfiguration.plannedPurgeDate) && Objects.equals(this.priority, chargeFlowLevelConfiguration.priority) && Objects.equals((Object)this.state, (Object)chargeFlowLevelConfiguration.state) && Objects.equals(this.type, chargeFlowLevelConfiguration.type) && Objects.equals(this.version, chargeFlowLevelConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flow, this.id, this.linkedSpaceId, this.name, this.period, this.plannedPurgeDate, this.priority, this.state, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeFlowLevelConfiguration {\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

