/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AnalyticsQueryExecution;
import ch.postfinance.sdk.model.AnalyticsSchemaColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A batch of the result of a query executed in Analytics.")
public class AnalyticsQueryResultBatch {
    @JsonProperty(value="columns")
    protected List<AnalyticsSchemaColumn> columns = null;
    @JsonProperty(value="nextToken")
    protected String nextToken = null;
    @JsonProperty(value="queryExecution")
    protected AnalyticsQueryExecution queryExecution = null;
    @JsonProperty(value="rows")
    protected List<List<String>> rows = null;

    @ApiModelProperty(value="The schemas of the columns returned by the query (in order). Will be null if the results of the query are not (yet) available.")
    public List<AnalyticsSchemaColumn> getColumns() {
        return this.columns;
    }

    @ApiModelProperty(value="The token to be provided to fetch the next batch of results. May be null if no more result batches are available.")
    public String getNextToken() {
        return this.nextToken;
    }

    @ApiModelProperty(value="The query execution which produced the result.")
    public AnalyticsQueryExecution getQueryExecution() {
        return this.queryExecution;
    }

    @ApiModelProperty(value="The rows of the result set contained in this batch where each row is a list of column values (in order of the columns specified in the query). Will be null if the results of the query are not (yet) available.")
    public List<List<String>> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsQueryResultBatch analyticsQueryResultBatch = (AnalyticsQueryResultBatch)o;
        return Objects.equals(this.columns, analyticsQueryResultBatch.columns) && Objects.equals(this.nextToken, analyticsQueryResultBatch.nextToken) && Objects.equals(this.queryExecution, analyticsQueryResultBatch.queryExecution) && Objects.equals(this.rows, analyticsQueryResultBatch.rows);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.nextToken, this.queryExecution, this.rows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsQueryResultBatch {\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    queryExecution: ").append(this.toIndentedString(this.queryExecution)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

