/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AnalyticsQueryExecutionState;
import ch.postfinance.sdk.model.FailureReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents the execution of a query which has been submitted to Analytics.")
public class AnalyticsQueryExecution {
    @JsonProperty(value="account")
    protected Long account = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="processingEndTime")
    protected OffsetDateTime processingEndTime = null;
    @JsonProperty(value="processingStartTime")
    protected OffsetDateTime processingStartTime = null;
    @JsonProperty(value="queryString")
    protected String queryString = null;
    @JsonProperty(value="scannedDataInGb")
    protected BigDecimal scannedDataInGb = null;
    @JsonProperty(value="scannedDataLimit")
    protected BigDecimal scannedDataLimit = null;
    @JsonProperty(value="spaces")
    protected List<Long> spaces = null;
    @JsonProperty(value="state")
    protected AnalyticsQueryExecutionState state = null;

    @ApiModelProperty(value="The account in which the query has been executed.")
    public Long getAccount() {
        return this.account;
    }

    @ApiModelProperty(value="The External ID of the query if one had been specified; otherwise null.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="The reason of the failure if and only if the query has failed, otherwise null.")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The time at which processing of the query has finished (either successfully or by failure or by cancelation). Will be null if the query execution has not finished yet.")
    public OffsetDateTime getProcessingEndTime() {
        return this.processingEndTime;
    }

    @ApiModelProperty(value="The time at which processing of the query has started (never null).")
    public OffsetDateTime getProcessingStartTime() {
        return this.processingStartTime;
    }

    @ApiModelProperty(value="The SQL statement which has been submitted for execution.")
    public String getQueryString() {
        return this.queryString;
    }

    @ApiModelProperty(value="The amount of data scanned while processing the query (in GB). (Note that this amount may increase over time while the query is still being processed and not finished yet.)")
    public BigDecimal getScannedDataInGb() {
        return this.scannedDataInGb;
    }

    @ApiModelProperty(value="The maximal amount of scanned data that this query is allowed to scan. After this limit is reached query will be canceled by the system. ")
    public BigDecimal getScannedDataLimit() {
        return this.scannedDataLimit;
    }

    @ApiModelProperty(value="The spaces in which the query has been executed. May be empty if all spaces of the specified account have been queried.")
    public List<Long> getSpaces() {
        return this.spaces;
    }

    @ApiModelProperty(value="The current state of the query execution.")
    public AnalyticsQueryExecutionState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsQueryExecution analyticsQueryExecution = (AnalyticsQueryExecution)o;
        return Objects.equals(this.account, analyticsQueryExecution.account) && Objects.equals(this.externalId, analyticsQueryExecution.externalId) && Objects.equals(this.failureReason, analyticsQueryExecution.failureReason) && Objects.equals(this.id, analyticsQueryExecution.id) && Objects.equals(this.processingEndTime, analyticsQueryExecution.processingEndTime) && Objects.equals(this.processingStartTime, analyticsQueryExecution.processingStartTime) && Objects.equals(this.queryString, analyticsQueryExecution.queryString) && Objects.equals(this.scannedDataInGb, analyticsQueryExecution.scannedDataInGb) && Objects.equals(this.scannedDataLimit, analyticsQueryExecution.scannedDataLimit) && Objects.equals(this.spaces, analyticsQueryExecution.spaces) && Objects.equals((Object)this.state, (Object)analyticsQueryExecution.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.externalId, this.failureReason, this.id, this.processingEndTime, this.processingStartTime, this.queryString, this.scannedDataInGb, this.scannedDataLimit, this.spaces, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsQueryExecution {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processingEndTime: ").append(this.toIndentedString(this.processingEndTime)).append("\n");
        sb.append("    processingStartTime: ").append(this.toIndentedString(this.processingStartTime)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    scannedDataInGb: ").append(this.toIndentedString(this.scannedDataInGb)).append("\n");
        sb.append("    scannedDataLimit: ").append(this.toIndentedString(this.scannedDataLimit)).append("\n");
        sb.append("    spaces: ").append(this.toIndentedString(this.spaces)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

