/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a query to be submitted for execution in Analytics.")
public class AnalyticsQuery {
    @JsonProperty(value="accountId")
    protected Long accountId = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="maxCacheAge")
    protected Integer maxCacheAge = null;
    @JsonProperty(value="queryString")
    protected String queryString = null;
    @JsonProperty(value="scannedDataLimit")
    protected BigDecimal scannedDataLimit = null;
    @JsonProperty(value="spaceIds")
    protected List<Long> spaceIds = null;

    public AnalyticsQuery accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The mandatory ID of an account in which the query shall be executed. Must be a valid account ID greater than 0.")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AnalyticsQuery externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(value="A client generated nonce which uniquely identifies the query to be executed. Subsequent submissions with the same external ID will not re-execute the query but instead return the existing execution with that ID. Either the External ID or a Maximal Cache Age greater than 0 must be specified. If both are specified the External ID will have precedence and the Maximal Cache Age will be ignored.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public AnalyticsQuery maxCacheAge(Integer maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    @ApiModelProperty(value="The maximal age in minutes of cached query executions to return. If an equivalent query execution with the same Query String, Account ID and Spaces parameters not older than the specified age is already available that execution will be returned instead of a newly started execution. Set to 0 or null (and set a unique, previously unused External ID) to force a new query execution irrespective of previous executions. Either the External ID or a Cache Duration greater than 0 must be specified. If both are specified, the External ID will be preferred (and the Maximal Cache Age ignored).")
    public Integer getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public void setMaxCacheAge(Integer maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    public AnalyticsQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @ApiModelProperty(value="The SQL statement which is being submitted for execution. Must be a valid PrestoDB/Athena SQL statement.")
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public AnalyticsQuery scannedDataLimit(BigDecimal scannedDataLimit) {
        this.scannedDataLimit = scannedDataLimit;
        return this;
    }

    @ApiModelProperty(value="The maximal amount of scanned data that this query is allowed to scan. After this limit is reached query will be canceled by the system. ")
    public BigDecimal getScannedDataLimit() {
        return this.scannedDataLimit;
    }

    public void setScannedDataLimit(BigDecimal scannedDataLimit) {
        this.scannedDataLimit = scannedDataLimit;
    }

    public AnalyticsQuery spaceIds(List<Long> spaceIds) {
        this.spaceIds = spaceIds;
        return this;
    }

    public AnalyticsQuery addSpaceIdsItem(Long spaceIdsItem) {
        if (this.spaceIds == null) {
            this.spaceIds = new ArrayList<Long>();
        }
        this.spaceIds.add(spaceIdsItem);
        return this;
    }

    @ApiModelProperty(value="The IDs of the spaces in which the query shall be executed. At most 5 space IDs may be specified. All specified spaces must be owned by the account specified by the accountId property. The spaces property may be missing or empty to query all spaces of the specified account.")
    public List<Long> getSpaceIds() {
        return this.spaceIds;
    }

    public void setSpaceIds(List<Long> spaceIds) {
        this.spaceIds = spaceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsQuery analyticsQuery = (AnalyticsQuery)o;
        return Objects.equals(this.accountId, analyticsQuery.accountId) && Objects.equals(this.externalId, analyticsQuery.externalId) && Objects.equals(this.maxCacheAge, analyticsQuery.maxCacheAge) && Objects.equals(this.queryString, analyticsQuery.queryString) && Objects.equals(this.scannedDataLimit, analyticsQuery.scannedDataLimit) && Objects.equals(this.spaceIds, analyticsQuery.spaceIds);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.externalId, this.maxCacheAge, this.queryString, this.scannedDataLimit, this.spaceIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsQuery {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    maxCacheAge: ").append(this.toIndentedString(this.maxCacheAge)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    scannedDataLimit: ").append(this.toIndentedString(this.scannedDataLimit)).append("\n");
        sb.append("    spaceIds: ").append(this.toIndentedString(this.spaceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

