/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.UserAccountRole;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class UserAccountRoleService {
    private ApiClient apiClient;

    public UserAccountRoleService(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserAccountRole addRole(Long userId, Long accountId, Long roleId, Boolean appliesOnSubaccount) throws IOException {
        HttpResponse response = this.addRoleForHttpResponse(userId, accountId, roleId, appliesOnSubaccount);
        String returnType = "UserAccountRole";
        if (returnType.equals("String")) {
            return (UserAccountRole)((Object)response.parseAsString());
        }
        TypeReference<UserAccountRole> typeRef = new TypeReference<UserAccountRole>(){};
        return (UserAccountRole)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public UserAccountRole addRole(Long userId, Long accountId, Long roleId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.addRoleForHttpResponse(userId, accountId, roleId, params);
        String returnType = "UserAccountRole";
        if (returnType.equals("String")) {
            return (UserAccountRole)((Object)response.parseAsString());
        }
        TypeReference<UserAccountRole> typeRef = new TypeReference<UserAccountRole>(){};
        return (UserAccountRole)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse addRoleForHttpResponse(Long userId, Long accountId, Long roleId, Boolean appliesOnSubaccount) throws IOException {
        Constable value;
        String key;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling addRole");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountId' when calling addRole");
        }
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling addRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/addRole"));
        if (userId != null) {
            key = "userId";
            value = userId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (accountId != null) {
            key = "accountId";
            value = accountId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (roleId != null) {
            key = "roleId";
            value = roleId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (appliesOnSubaccount != null) {
            key = "appliesOnSubaccount";
            value = appliesOnSubaccount;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse addRoleForHttpResponse(Long userId, Long accountId, Long roleId, Map<String, Object> params) throws IOException {
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling addRole");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountId' when calling addRole");
        }
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling addRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/addRole"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("userId", userId);
        allParams.put("accountId", accountId);
        allParams.put("roleId", roleId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<UserAccountRole> list(Long userId, Long accountId) throws IOException {
        HttpResponse response = this.listForHttpResponse(userId, accountId);
        String returnType = "List&lt;UserAccountRole&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<UserAccountRole>> typeRef = new TypeReference<List<UserAccountRole>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<UserAccountRole> list(Long userId, Long accountId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.listForHttpResponse(userId, accountId, params);
        String returnType = "List&lt;UserAccountRole&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<UserAccountRole>> typeRef = new TypeReference<List<UserAccountRole>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse listForHttpResponse(Long userId, Long accountId) throws IOException {
        Long value;
        String key;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling list");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountId' when calling list");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/list"));
        if (userId != null) {
            key = "userId";
            value = userId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (accountId != null) {
            key = "accountId";
            value = accountId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse listForHttpResponse(Long userId, Long accountId, Map<String, Object> params) throws IOException {
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling list");
        }
        if (accountId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountId' when calling list");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/list"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("userId", userId);
        allParams.put("accountId", accountId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void removeRole(Long id) throws IOException {
        this.removeRoleForHttpResponse(id);
    }

    public void removeRole(Long id, Map<String, Object> params) throws IOException {
        this.removeRoleForHttpResponse(id, params);
    }

    public HttpResponse removeRoleForHttpResponse(Long id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling removeRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/removeRole"));
        if (id != null) {
            String key = "id";
            Long value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse removeRoleForHttpResponse(Long id, Map<String, Object> params) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling removeRole");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/user-account-role/removeRole"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }
}

