/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Address;
import ch.postfinance.sdk.model.ChargeAttemptEnvironment;
import ch.postfinance.sdk.model.Label;
import ch.postfinance.sdk.model.PaymentConnectorConfiguration;
import ch.postfinance.sdk.model.PaymentInformationHash;
import ch.postfinance.sdk.model.Token;
import ch.postfinance.sdk.model.TokenVersionState;
import ch.postfinance.sdk.model.TokenVersionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class TokenVersion {
    @JsonProperty(value="activatedOn")
    protected OffsetDateTime activatedOn = null;
    @JsonProperty(value="billingAddress")
    protected Address billingAddress = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="environment")
    protected ChargeAttemptEnvironment environment = null;
    @JsonProperty(value="expiresOn")
    protected OffsetDateTime expiresOn = null;
    @JsonProperty(value="iconUrl")
    protected String iconUrl = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="labels")
    protected List<Label> labels = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="obsoletedOn")
    protected OffsetDateTime obsoletedOn = null;
    @JsonProperty(value="paymentConnectorConfiguration")
    protected PaymentConnectorConfiguration paymentConnectorConfiguration = null;
    @JsonProperty(value="paymentInformationHashes")
    protected List<PaymentInformationHash> paymentInformationHashes = null;
    @JsonProperty(value="paymentMethod")
    protected Long paymentMethod = null;
    @JsonProperty(value="paymentMethodBrand")
    protected Long paymentMethodBrand = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="processorToken")
    protected String processorToken = null;
    @JsonProperty(value="shippingAddress")
    protected Address shippingAddress = null;
    @JsonProperty(value="state")
    protected TokenVersionState state = null;
    @JsonProperty(value="token")
    protected Token token = null;
    @JsonProperty(value="type")
    protected TokenVersionType type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public OffsetDateTime getActivatedOn() {
        return this.activatedOn;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="")
    public ChargeAttemptEnvironment getEnvironment() {
        return this.environment;
    }

    @ApiModelProperty(value="The expires on date indicates when token version expires. Once this date is reached the token version is marked as obsolete.")
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    @ApiModelProperty(value="")
    public String getIconUrl() {
        return this.iconUrl;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getObsoletedOn() {
        return this.obsoletedOn;
    }

    @ApiModelProperty(value="")
    public PaymentConnectorConfiguration getPaymentConnectorConfiguration() {
        return this.paymentConnectorConfiguration;
    }

    @ApiModelProperty(value="The payment information hash set contains hashes of the payment information represented by this token version.")
    public List<PaymentInformationHash> getPaymentInformationHashes() {
        return this.paymentInformationHashes;
    }

    @ApiModelProperty(value="")
    public Long getPaymentMethod() {
        return this.paymentMethod;
    }

    @ApiModelProperty(value="")
    public Long getPaymentMethodBrand() {
        return this.paymentMethodBrand;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public String getProcessorToken() {
        return this.processorToken;
    }

    @ApiModelProperty(value="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @ApiModelProperty(value="")
    public TokenVersionState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public Token getToken() {
        return this.token;
    }

    @ApiModelProperty(value="The token version type determines what kind of token it is and by which payment connector the token can be processed by.")
    public TokenVersionType getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenVersion tokenVersion = (TokenVersion)o;
        return Objects.equals(this.activatedOn, tokenVersion.activatedOn) && Objects.equals(this.billingAddress, tokenVersion.billingAddress) && Objects.equals(this.createdOn, tokenVersion.createdOn) && Objects.equals((Object)this.environment, (Object)tokenVersion.environment) && Objects.equals(this.expiresOn, tokenVersion.expiresOn) && Objects.equals(this.iconUrl, tokenVersion.iconUrl) && Objects.equals(this.id, tokenVersion.id) && Objects.equals(this.labels, tokenVersion.labels) && Objects.equals(this.language, tokenVersion.language) && Objects.equals(this.linkedSpaceId, tokenVersion.linkedSpaceId) && Objects.equals(this.name, tokenVersion.name) && Objects.equals(this.obsoletedOn, tokenVersion.obsoletedOn) && Objects.equals(this.paymentConnectorConfiguration, tokenVersion.paymentConnectorConfiguration) && Objects.equals(this.paymentInformationHashes, tokenVersion.paymentInformationHashes) && Objects.equals(this.paymentMethod, tokenVersion.paymentMethod) && Objects.equals(this.paymentMethodBrand, tokenVersion.paymentMethodBrand) && Objects.equals(this.plannedPurgeDate, tokenVersion.plannedPurgeDate) && Objects.equals(this.processorToken, tokenVersion.processorToken) && Objects.equals(this.shippingAddress, tokenVersion.shippingAddress) && Objects.equals((Object)this.state, (Object)tokenVersion.state) && Objects.equals(this.token, tokenVersion.token) && Objects.equals(this.type, tokenVersion.type) && Objects.equals(this.version, tokenVersion.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activatedOn, this.billingAddress, this.createdOn, this.environment, this.expiresOn, this.iconUrl, this.id, this.labels, this.language, this.linkedSpaceId, this.name, this.obsoletedOn, this.paymentConnectorConfiguration, this.paymentInformationHashes, this.paymentMethod, this.paymentMethodBrand, this.plannedPurgeDate, this.processorToken, this.shippingAddress, this.state, this.token, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenVersion {\n");
        sb.append("    activatedOn: ").append(this.toIndentedString(this.activatedOn)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    expiresOn: ").append(this.toIndentedString(this.expiresOn)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    obsoletedOn: ").append(this.toIndentedString(this.obsoletedOn)).append("\n");
        sb.append("    paymentConnectorConfiguration: ").append(this.toIndentedString(this.paymentConnectorConfiguration)).append("\n");
        sb.append("    paymentInformationHashes: ").append(this.toIndentedString(this.paymentInformationHashes)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentMethodBrand: ").append(this.toIndentedString(this.paymentMethodBrand)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

