/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Account;
import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.SpaceAddress;
import ch.postfinance.sdk.model.TenantDatabase;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class Space {
    @JsonProperty(value="account")
    protected Account account = null;
    @JsonProperty(value="active")
    protected Boolean active = null;
    @JsonProperty(value="activeOrRestrictedActive")
    protected Boolean activeOrRestrictedActive = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="database")
    protected TenantDatabase database = null;
    @JsonProperty(value="deletedBy")
    protected Long deletedBy = null;
    @JsonProperty(value="deletedOn")
    protected OffsetDateTime deletedOn = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="lastModifiedDate")
    protected OffsetDateTime lastModifiedDate = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="postalAddress")
    protected SpaceAddress postalAddress = null;
    @JsonProperty(value="primaryCurrency")
    protected String primaryCurrency = null;
    @JsonProperty(value="requestLimit")
    protected Long requestLimit = null;
    @JsonProperty(value="restrictedActive")
    protected Boolean restrictedActive = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="technicalContactAddresses")
    protected List<String> technicalContactAddresses = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The account to which the space belongs to.")
    public Account getAccount() {
        return this.account;
    }

    @ApiModelProperty(value="Active means that this account and all accounts in the hierarchy are active.")
    public Boolean isActive() {
        return this.active;
    }

    @ApiModelProperty(value="This property is true when all accounts in the hierarchy are active or restricted active.")
    public Boolean isActiveOrRestrictedActive() {
        return this.activeOrRestrictedActive;
    }

    @ApiModelProperty(value="The ID of the user who created this entity.")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The date and time when this entity was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The database in which the space's data are stored in.")
    public TenantDatabase getDatabase() {
        return this.database;
    }

    @ApiModelProperty(value="The ID of a user that deleted this entity.")
    public Long getDeletedBy() {
        return this.deletedBy;
    }

    @ApiModelProperty(value="The date and time when this entity was deleted.")
    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @ApiModelProperty(value="The space name is used internally to identify the space in administrative interfaces. For example it is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The address to use in communication with clients for example in email, documents etc.")
    public SpaceAddress getPostalAddress() {
        return this.postalAddress;
    }

    @ApiModelProperty(value="This is the currency that is used to display aggregated amounts in the space.")
    public String getPrimaryCurrency() {
        return this.primaryCurrency;
    }

    @ApiModelProperty(value="The request limit defines the maximum number of API request accepted within 2 minutes for this space. This limit can only be changed with special privileges.")
    public Long getRequestLimit() {
        return this.requestLimit;
    }

    @ApiModelProperty(value="Restricted active means that at least one account in the hierarchy is only restricted active, but all are either restricted active or active.")
    public Boolean isRestrictedActive() {
        return this.restrictedActive;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The email address provided as contact addresses will be informed about technical issues or errors triggered by the space.")
    public List<String> getTechnicalContactAddresses() {
        return this.technicalContactAddresses;
    }

    @ApiModelProperty(value="The time zone assigned to the space determines the time offset for calculating dates within the space. This is typically used for background processed which needs to be triggered on a specific hour within the day. Changing the space time zone will not change the display of dates.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Space space = (Space)o;
        return Objects.equals(this.account, space.account) && Objects.equals(this.active, space.active) && Objects.equals(this.activeOrRestrictedActive, space.activeOrRestrictedActive) && Objects.equals(this.createdBy, space.createdBy) && Objects.equals(this.createdOn, space.createdOn) && Objects.equals(this.database, space.database) && Objects.equals(this.deletedBy, space.deletedBy) && Objects.equals(this.deletedOn, space.deletedOn) && Objects.equals(this.id, space.id) && Objects.equals(this.lastModifiedDate, space.lastModifiedDate) && Objects.equals(this.name, space.name) && Objects.equals(this.plannedPurgeDate, space.plannedPurgeDate) && Objects.equals(this.postalAddress, space.postalAddress) && Objects.equals(this.primaryCurrency, space.primaryCurrency) && Objects.equals(this.requestLimit, space.requestLimit) && Objects.equals(this.restrictedActive, space.restrictedActive) && Objects.equals((Object)this.state, (Object)space.state) && Objects.equals(this.technicalContactAddresses, space.technicalContactAddresses) && Objects.equals(this.timeZone, space.timeZone) && Objects.equals(this.version, space.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.active, this.activeOrRestrictedActive, this.createdBy, this.createdOn, this.database, this.deletedBy, this.deletedOn, this.id, this.lastModifiedDate, this.name, this.plannedPurgeDate, this.postalAddress, this.primaryCurrency, this.requestLimit, this.restrictedActive, this.state, this.technicalContactAddresses, this.timeZone, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Space {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    activeOrRestrictedActive: ").append(this.toIndentedString(this.activeOrRestrictedActive)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    deletedBy: ").append(this.toIndentedString(this.deletedBy)).append("\n");
        sb.append("    deletedOn: ").append(this.toIndentedString(this.deletedOn)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastModifiedDate: ").append(this.toIndentedString(this.lastModifiedDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    postalAddress: ").append(this.toIndentedString(this.postalAddress)).append("\n");
        sb.append("    primaryCurrency: ").append(this.toIndentedString(this.primaryCurrency)).append("\n");
        sb.append("    requestLimit: ").append(this.toIndentedString(this.requestLimit)).append("\n");
        sb.append("    restrictedActive: ").append(this.toIndentedString(this.restrictedActive)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    technicalContactAddresses: ").append(this.toIndentedString(this.technicalContactAddresses)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

