/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.ResourcePath;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="A document template contains the customizations for a particular document template type.")
public class DocumentTemplate {
    @JsonProperty(value="defaultTemplate")
    protected Boolean defaultTemplate = null;
    @JsonProperty(value="deliveryEnabled")
    protected Boolean deliveryEnabled = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="spaceId")
    protected Long spaceId = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="templateResource")
    protected ResourcePath templateResource = null;
    @JsonProperty(value="type")
    protected Long type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The default document template is used whenever no specific template is specified for a particular template type.")
    public Boolean isDefaultTemplate() {
        return this.defaultTemplate;
    }

    @ApiModelProperty(value="")
    public Boolean isDeliveryEnabled() {
        return this.deliveryEnabled;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public Long getSpaceId() {
        return this.spaceId;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public ResourcePath getTemplateResource() {
        return this.templateResource;
    }

    @ApiModelProperty(value="")
    public Long getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentTemplate documentTemplate = (DocumentTemplate)o;
        return Objects.equals(this.defaultTemplate, documentTemplate.defaultTemplate) && Objects.equals(this.deliveryEnabled, documentTemplate.deliveryEnabled) && Objects.equals(this.id, documentTemplate.id) && Objects.equals(this.linkedSpaceId, documentTemplate.linkedSpaceId) && Objects.equals(this.name, documentTemplate.name) && Objects.equals(this.plannedPurgeDate, documentTemplate.plannedPurgeDate) && Objects.equals(this.spaceId, documentTemplate.spaceId) && Objects.equals((Object)this.state, (Object)documentTemplate.state) && Objects.equals(this.templateResource, documentTemplate.templateResource) && Objects.equals(this.type, documentTemplate.type) && Objects.equals(this.version, documentTemplate.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultTemplate, this.deliveryEnabled, this.id, this.linkedSpaceId, this.name, this.plannedPurgeDate, this.spaceId, this.state, this.templateResource, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentTemplate {\n");
        sb.append("    defaultTemplate: ").append(this.toIndentedString(this.defaultTemplate)).append("\n");
        sb.append("    deliveryEnabled: ").append(this.toIndentedString(this.deliveryEnabled)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    spaceId: ").append(this.toIndentedString(this.spaceId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    templateResource: ").append(this.toIndentedString(this.templateResource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

