/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AccountState;
import ch.postfinance.sdk.model.AccountType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class Account {
    @JsonProperty(value="active")
    protected Boolean active = null;
    @JsonProperty(value="activeOrRestrictedActive")
    protected Boolean activeOrRestrictedActive = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="deletedBy")
    protected Long deletedBy = null;
    @JsonProperty(value="deletedOn")
    protected OffsetDateTime deletedOn = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="lastModifiedDate")
    protected OffsetDateTime lastModifiedDate = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="parentAccount")
    protected Account parentAccount = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="restrictedActive")
    protected Boolean restrictedActive = null;
    @JsonProperty(value="scope")
    protected Long scope = null;
    @JsonProperty(value="state")
    protected AccountState state = null;
    @JsonProperty(value="subaccountLimit")
    protected Long subaccountLimit = null;
    @JsonProperty(value="type")
    protected AccountType type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="Active means that this account and all accounts in the hierarchy are active.")
    public Boolean isActive() {
        return this.active;
    }

    @ApiModelProperty(value="This property is true when all accounts in the hierarchy are active or restricted active.")
    public Boolean isActiveOrRestrictedActive() {
        return this.activeOrRestrictedActive;
    }

    @ApiModelProperty(value="The ID of the user who created this entity.")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The date and time when this entity was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The ID of a user that deleted this entity.")
    public Long getDeletedBy() {
        return this.deletedBy;
    }

    @ApiModelProperty(value="The date and time when this entity was deleted.")
    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @ApiModelProperty(value="The name of the account identifies the account within the administrative interface.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The account which is responsible for administering the account.")
    public Account getParentAccount() {
        return this.parentAccount;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="Restricted active means that at least one account in the hierarchy is only restricted active, but all are either restricted active or active.")
    public Boolean isRestrictedActive() {
        return this.restrictedActive;
    }

    @ApiModelProperty(value="This is the scope to which the account belongs to.")
    public Long getScope() {
        return this.scope;
    }

    @ApiModelProperty(value="")
    public AccountState getState() {
        return this.state;
    }

    @ApiModelProperty(value="This property restricts the number of subaccounts which can be created within this account.")
    public Long getSubaccountLimit() {
        return this.subaccountLimit;
    }

    @ApiModelProperty(value="The account type defines which role and capabilities it has.")
    public AccountType getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.active, account.active) && Objects.equals(this.activeOrRestrictedActive, account.activeOrRestrictedActive) && Objects.equals(this.createdBy, account.createdBy) && Objects.equals(this.createdOn, account.createdOn) && Objects.equals(this.deletedBy, account.deletedBy) && Objects.equals(this.deletedOn, account.deletedOn) && Objects.equals(this.id, account.id) && Objects.equals(this.lastModifiedDate, account.lastModifiedDate) && Objects.equals(this.name, account.name) && Objects.equals(this.parentAccount, account.parentAccount) && Objects.equals(this.plannedPurgeDate, account.plannedPurgeDate) && Objects.equals(this.restrictedActive, account.restrictedActive) && Objects.equals(this.scope, account.scope) && Objects.equals((Object)this.state, (Object)account.state) && Objects.equals(this.subaccountLimit, account.subaccountLimit) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals(this.version, account.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.active, this.activeOrRestrictedActive, this.createdBy, this.createdOn, this.deletedBy, this.deletedOn, this.id, this.lastModifiedDate, this.name, this.parentAccount, this.plannedPurgeDate, this.restrictedActive, this.scope, this.state, this.subaccountLimit, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    activeOrRestrictedActive: ").append(this.toIndentedString(this.activeOrRestrictedActive)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    deletedBy: ").append(this.toIndentedString(this.deletedBy)).append("\n");
        sb.append("    deletedOn: ").append(this.toIndentedString(this.deletedOn)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastModifiedDate: ").append(this.toIndentedString(this.lastModifiedDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentAccount: ").append(this.toIndentedString(this.parentAccount)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    restrictedActive: ").append(this.toIndentedString(this.restrictedActive)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    subaccountLimit: ").append(this.toIndentedString(this.subaccountLimit)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

