/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class AbstractTokenUpdate {
    @JsonProperty(value="customerEmailAddress")
    protected String customerEmailAddress = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="enabledForOneClickPayment")
    protected Boolean enabledForOneClickPayment = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="tokenReference")
    protected String tokenReference = null;

    public AbstractTokenUpdate customerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
        return this;
    }

    @ApiModelProperty(value="The customer email address is the email address of the customer.")
    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public AbstractTokenUpdate customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(value="The customer ID identifies the customer in the merchant system. In case the customer ID has been provided it has to correspond with the customer ID provided on the transaction. The customer ID will not be changed automatically. The merchant system has to provide it.")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public AbstractTokenUpdate enabledForOneClickPayment(Boolean enabledForOneClickPayment) {
        this.enabledForOneClickPayment = enabledForOneClickPayment;
        return this;
    }

    @ApiModelProperty(value="When a token is enabled for one-click payments the buyer will be able to select the token within the iFrame or on the payment page to pay with the token. The usage of the token will reduce the number of steps the buyer has to go through. The buyer is linked via the customer ID on the transaction with the token. Means the token will be visible for buyers with the same customer ID. Additionally the payment method has to be configured to allow the one-click payments.")
    public Boolean isEnabledForOneClickPayment() {
        return this.enabledForOneClickPayment;
    }

    public void setEnabledForOneClickPayment(Boolean enabledForOneClickPayment) {
        this.enabledForOneClickPayment = enabledForOneClickPayment;
    }

    public AbstractTokenUpdate language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AbstractTokenUpdate timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone defines in which time zone the customer is located in. The time zone may affects how dates are formatted when interacting with the customer.")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public AbstractTokenUpdate tokenReference(String tokenReference) {
        this.tokenReference = tokenReference;
        return this;
    }

    @ApiModelProperty(value="Use something that it is easy to identify and may help you find the token (e.g. customer id, email address).")
    public String getTokenReference() {
        return this.tokenReference;
    }

    public void setTokenReference(String tokenReference) {
        this.tokenReference = tokenReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTokenUpdate abstractTokenUpdate = (AbstractTokenUpdate)o;
        return Objects.equals(this.customerEmailAddress, abstractTokenUpdate.customerEmailAddress) && Objects.equals(this.customerId, abstractTokenUpdate.customerId) && Objects.equals(this.enabledForOneClickPayment, abstractTokenUpdate.enabledForOneClickPayment) && Objects.equals(this.language, abstractTokenUpdate.language) && Objects.equals(this.timeZone, abstractTokenUpdate.timeZone) && Objects.equals(this.tokenReference, abstractTokenUpdate.tokenReference);
    }

    public int hashCode() {
        return Objects.hash(this.customerEmailAddress, this.customerId, this.enabledForOneClickPayment, this.language, this.timeZone, this.tokenReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbstractTokenUpdate {\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    enabledForOneClickPayment: ").append(this.toIndentedString(this.enabledForOneClickPayment)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    tokenReference: ").append(this.toIndentedString(this.tokenReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

