/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.conditionalrestrictionparser;

import ch.poole.conditionalrestrictionparser.Condition;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Conditions {
    private final List<Condition> conditionList;
    private boolean conditionsInParen = false;

    public Conditions(@NotNull List<Condition> conditions, boolean conditionsInParen) {
        this.conditionList = conditions;
        this.conditionsInParen = conditionsInParen;
    }

    @NotNull
    public List<Condition> getConditions() {
        return this.conditionList;
    }

    public void addCondition(@NotNull Condition c) {
        this.conditionList.add(c);
    }

    public void removeCondition(@NotNull Condition c) {
        this.conditionList.remove(c);
    }

    public boolean inParen() {
        return this.conditionsInParen;
    }

    public void setInParen() {
        this.conditionsInParen = true;
    }

    public void clearInParen() {
        this.conditionsInParen = false;
    }

    public String prettyPrint() {
        StringBuilder b = new StringBuilder();
        if (this.conditionsInParen) {
            b.append("(" + System.lineSeparator());
        }
        boolean first = true;
        for (Condition c : this.conditionList) {
            if (!first) {
                b.append(System.lineSeparator());
                if (this.conditionsInParen) {
                    b.append(" ");
                }
                b.append("AND ");
            } else {
                first = false;
                if (this.conditionsInParen) {
                    b.append(" ");
                }
            }
            b.append(c);
        }
        if (this.conditionsInParen) {
            b.append(System.lineSeparator() + ")");
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean keepEmpty) {
        StringBuilder b = new StringBuilder();
        if (this.conditionsInParen) {
            b.append("(");
        }
        boolean first = true;
        for (Condition c : this.conditionList) {
            String term1 = c.term1();
            if ((term1 == null || "".equals(term1)) && !keepEmpty) continue;
            if (!first) {
                b.append(" AND ");
            } else {
                first = false;
            }
            b.append(c);
        }
        if (this.conditionsInParen) {
            b.append(")");
        }
        return b.toString();
    }

    public void reverse() {
        Collections.reverse(this.conditionList);
    }
}

