/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.conditionalrestrictionparser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Condition {
    private boolean isOH = false;
    private String c;
    private String c2;
    private CompOp op = null;
    public static final List<String> compOpStrings = Collections.unmodifiableList(Arrays.asList("=", ">", ">=", "<", "<="));

    public Condition(@NotNull String c, boolean isOH) {
        this.c = c.trim();
        this.isOH = isOH;
    }

    public Condition(@NotNull String c, @NotNull CompOp op, @NotNull String c2) {
        this.c = c.trim();
        this.op = op;
        this.c2 = c2.trim();
    }

    public String toString() {
        return this.c.trim() + (this.op != null ? Condition.opToString(this.op) + this.c2.trim() : "");
    }

    public static String opToString(@NotNull CompOp op) {
        switch (op) {
            case EQ: {
                return "=";
            }
            case GT: {
                return ">";
            }
            case GTEQ: {
                return ">=";
            }
            case LT: {
                return "<";
            }
            case LTEQ: {
                return "<=";
            }
        }
        return "";
    }

    public static CompOp stringToOp(@Nullable String s) {
        if ("=".equals(s)) {
            return CompOp.EQ;
        }
        if (">".equals(s)) {
            return CompOp.GT;
        }
        if (">=".equals(s)) {
            return CompOp.GTEQ;
        }
        if ("<".equals(s)) {
            return CompOp.LT;
        }
        if ("<=".equals(s)) {
            return CompOp.LTEQ;
        }
        return null;
    }

    public boolean isOpeningHours() {
        return this.isOH;
    }

    public boolean isExpression() {
        return this.op != null && this.c2 != null;
    }

    public String term1() {
        return this.c;
    }

    public void setTerm1(String term) {
        this.c = term;
    }

    public String term2() {
        return this.c2;
    }

    public void setTerm2(String term) {
        this.c2 = term;
    }

    public CompOp operator() {
        return this.op;
    }

    public static enum CompOp {
        EQ,
        GT,
        GTEQ,
        LT,
        LTEQ;

    }
}

