/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.conditionalrestrictionparser;

import ch.poole.conditionalrestrictionparser.Condition;
import java.util.Collections;
import java.util.List;

public class Conditions {
    final List<Condition> conditions;
    boolean conditionsInParen = false;

    public Conditions(List<Condition> conditions, boolean conditionsInParen) {
        this.conditions = conditions;
        this.conditionsInParen = conditionsInParen;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void addCondition(Condition c) {
        this.conditions.add(c);
    }

    public void removeCondition(Condition c) {
        this.conditions.remove(c);
    }

    public boolean inParen() {
        return this.conditionsInParen;
    }

    public void setInParen() {
        this.conditionsInParen = true;
    }

    public void clearInParen() {
        this.conditionsInParen = false;
    }

    public String prettyPrint() {
        StringBuilder b = new StringBuilder();
        if (this.conditionsInParen) {
            b.append("(\n");
        }
        boolean first = true;
        boolean multiple = this.conditions.size() > 1;
        for (Condition c : this.conditions) {
            if (!first) {
                b.append("\n");
                if (this.conditionsInParen) {
                    b.append(" ");
                }
                b.append("AND ");
            } else {
                first = false;
                if (this.conditionsInParen) {
                    b.append(" ");
                }
            }
            b.append(c);
        }
        if (this.conditionsInParen) {
            b.append("\n)");
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean keepEmpty) {
        StringBuilder b = new StringBuilder();
        if (this.conditionsInParen) {
            b.append("(");
        }
        boolean first = true;
        for (Condition c : this.conditions) {
            String term1 = c.term1();
            if ((term1 == null || "".equals(term1)) && !keepEmpty) continue;
            if (!first) {
                b.append(" AND ");
            } else {
                first = false;
            }
            b.append(c);
        }
        if (this.conditionsInParen) {
            b.append(")");
        }
        return b.toString();
    }

    public void reverse() {
        Collections.reverse(this.conditions);
    }
}

