/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.conditionalrestrictionparser;

import ch.poole.conditionalrestrictionparser.I18n;
import ch.poole.conditionalrestrictionparser.ParseException;
import ch.poole.conditionalrestrictionparser.Token;
import org.jetbrains.annotations.Nullable;

public class ConditionalRestrictionParseException
extends ParseException {
    private final int line;
    private final int column;
    private String encountered = null;
    private String expected = null;

    ConditionalRestrictionParseException(String message) {
        this(message, -1, -1);
    }

    ConditionalRestrictionParseException(String message, @Nullable Token token) {
        this(message, token != null ? token.beginLine : -1, token != null ? token.beginColumn : -1);
    }

    private ConditionalRestrictionParseException(String message, int line, int column) {
        super(message);
        this.line = line;
        this.column = column;
    }

    ConditionalRestrictionParseException(ParseException ex) {
        this(null, ex.currentToken);
        this.currentToken = ex.currentToken;
        this.expectedTokenSequences = ex.expectedTokenSequences;
        this.tokenImage = ex.tokenImage;
        this.setEncounteredExpected();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public String getMessage() {
        String message = this.encountered == null || this.encountered.isEmpty() ? super.getMessage() : I18n.tr("exception_encountered", this.encountered);
        String string = this.line >= 0 && this.column >= 0 ? I18n.tr("exception_line_column", message, this.line, this.column) : message;
        String appendix = this.expected == null || this.expected.isEmpty() ? "" : EOL + I18n.tr("exception_expecting", this.expected);
        return string + appendix;
    }

    private void setEncounteredExpected() {
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int[] expectedTokenSequence : this.expectedTokenSequences) {
            if (maxSize < expectedTokenSequence.length) {
                maxSize = expectedTokenSequence.length;
            }
            for (int i : expectedTokenSequence) {
                expected.append(this.tokenImage[i]).append(' ');
            }
            if (expectedTokenSequence[expectedTokenSequence.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(EOL).append("    ");
        }
        this.expected = expected.toString().trim();
        StringBuilder encountered = new StringBuilder();
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                encountered.append(" ");
            }
            if (tok.kind == 0) {
                encountered.append(this.tokenImage[0]);
                break;
            }
            encountered.append(" ").append(this.tokenImage[tok.kind]);
            encountered.append(" \"");
            encountered.append(ConditionalRestrictionParseException.add_escapes(tok.image));
            encountered.append(" \"");
            tok = tok.next;
        }
        this.encountered = encountered.toString();
    }
}

