/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.conditionalrestrictionparser;

import java.util.Arrays;
import java.util.List;

public class Condition {
    boolean OH = false;
    String c;
    String c2;
    CompOp op = null;
    public static List<String> compOpStrings = Arrays.asList("=", ">", ">=", "<", "<=");

    public Condition(String c, boolean OH) {
        this.c = c.trim();
        this.OH = OH;
    }

    public Condition(String c, CompOp op, String c2) {
        this.c = c.trim();
        this.op = op;
        this.c2 = c2.trim();
    }

    public String toString() {
        return this.c.trim() + (this.op != null ? Condition.opToString(this.op) + this.c2.trim() : "");
    }

    public static String opToString(CompOp op) {
        switch (op) {
            case EQ: {
                return "=";
            }
            case GT: {
                return ">";
            }
            case GTEQ: {
                return ">=";
            }
            case LT: {
                return "<";
            }
            case LTEQ: {
                return "<=";
            }
        }
        return "";
    }

    public static CompOp stringToOp(String s) {
        if ("=".equals(s)) {
            return CompOp.EQ;
        }
        if (">".equals(s)) {
            return CompOp.GT;
        }
        if (">=".equals(s)) {
            return CompOp.GTEQ;
        }
        if ("<".equals(s)) {
            return CompOp.LT;
        }
        if ("<=".equals(s)) {
            return CompOp.LTEQ;
        }
        return null;
    }

    public boolean isOpeningHours() {
        return this.OH;
    }

    public boolean isExpression() {
        return this.op != null && this.c2 != null;
    }

    public String term1() {
        return this.c;
    }

    public void setTerm1(String term) {
        this.c = term;
    }

    public String term2() {
        return this.c2;
    }

    public void setTerm2(String term) {
        this.c2 = term;
    }

    public CompOp operator() {
        return this.op;
    }

    public static enum CompOp {
        EQ,
        GT,
        GTEQ,
        LT,
        LTEQ;

    }
}

