/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java.name;

import ch.obermuhlner.scriptengine.java.name.NameStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;

public class DefaultNameStrategy
implements NameStrategy {
    private static final Pattern NAME_PATTERN = Pattern.compile("public\\s+class\\s+([A-Za-z][A-Za-z0-9_$]*)");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([A-Za-z][A-Za-z0-9_$.]*)");

    @Override
    public String getFullName(String script) throws ScriptException {
        Matcher nameMatcher;
        String fullPackage = null;
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(script);
        if (packageMatcher.find()) {
            fullPackage = packageMatcher.group(1);
        }
        if ((nameMatcher = NAME_PATTERN.matcher(script)).find()) {
            String name = nameMatcher.group(1);
            if (fullPackage == null) {
                return name;
            }
            return fullPackage + "." + name;
        }
        throw new ScriptException("Could not determine fully qualified class name");
    }
}

