/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java;

import ch.obermuhlner.scriptengine.java.Isolation;
import ch.obermuhlner.scriptengine.java.JavaCompiledScript;
import ch.obermuhlner.scriptengine.java.JavaScriptEngineFactory;
import ch.obermuhlner.scriptengine.java.MemoryFileManager;
import ch.obermuhlner.scriptengine.java.constructor.ConstructorStrategy;
import ch.obermuhlner.scriptengine.java.constructor.DefaultConstructorStrategy;
import ch.obermuhlner.scriptengine.java.execution.DefaultExecutionStrategy;
import ch.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import ch.obermuhlner.scriptengine.java.execution.ExecutionStrategyFactory;
import ch.obermuhlner.scriptengine.java.name.DefaultNameStrategy;
import ch.obermuhlner.scriptengine.java.name.NameStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavaScriptEngine
implements ScriptEngine,
Compilable {
    private NameStrategy nameStrategy = new DefaultNameStrategy();
    private ConstructorStrategy constructorStrategy = DefaultConstructorStrategy.byDefaultConstructor();
    private ExecutionStrategyFactory executionStrategyFactory = clazz -> new DefaultExecutionStrategy(clazz);
    private Isolation isolation = Isolation.CallerClassLoader;
    private ScriptContext context = new SimpleScriptContext();
    private ClassLoader executionClassLoader = this.getClass().getClassLoader();

    public void setNameStrategy(NameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    public void setConstructorStrategy(ConstructorStrategy constructorStrategy) {
        this.constructorStrategy = constructorStrategy;
    }

    public void setExecutionStrategyFactory(ExecutionStrategyFactory executionStrategyFactory) {
        this.executionStrategyFactory = executionStrategyFactory;
    }

    public void setExecutionClassLoader(ClassLoader executionClassLoader) {
        this.executionClassLoader = executionClassLoader;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(this.readScript(reader));
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readScript(reader), context);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(script, context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(this.readScript(reader), bindings);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        JavaCompiledScript compile = this.compile(script);
        return compile.eval(bindings);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readScript(reader));
    }

    @Override
    public JavaCompiledScript compile(String script) throws ScriptException {
        String fullClassName;
        String simpleClassName;
        JavaFileObject scriptSource;
        ClassLoader parentClassLoader;
        DiagnosticCollector diagnostics;
        StandardJavaFileManager standardFileManager;
        MemoryFileManager memoryFileManager;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaCompiler.CompilationTask task = compiler.getTask(null, memoryFileManager = new MemoryFileManager(standardFileManager = compiler.getStandardFileManager(diagnostics = new DiagnosticCollector(), null, null), parentClassLoader = this.isolation == Isolation.CallerClassLoader ? this.executionClassLoader : null), diagnostics, null, null, Arrays.asList(scriptSource = memoryFileManager.createSourceFileObject(null, simpleClassName = NameStrategy.extractSimpleName(fullClassName = this.nameStrategy.getFullName(script)), script)));
        if (!task.call().booleanValue()) {
            String message = diagnostics.getDiagnostics().stream().map(d -> d.toString()).collect(Collectors.joining("\n"));
            throw new ScriptException(message);
        }
        ClassLoader classLoader = memoryFileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        try {
            Class<?> clazz = classLoader.loadClass(fullClassName);
            Object instance = this.constructorStrategy.construct(clazz);
            ExecutionStrategy executionStrategy = this.executionStrategyFactory.create(clazz);
            return new JavaCompiledScript(this, clazz, instance, executionStrategy);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new JavaScriptEngineFactory();
    }

    private String readScript(Reader reader) throws ScriptException {
        try {
            String line;
            StringBuilder s = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                s.append(line);
                s.append("\n");
            }
            return s.toString();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }
}

