/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T>[] iterators;
    private int iteratorIndex = 0;

    public CompositeIterator(Iterator<? extends T> ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorIndex >= this.iterators.length) {
            return false;
        }
        if (this.iterators[this.iteratorIndex].hasNext()) {
            return true;
        }
        ++this.iteratorIndex;
        if (this.iteratorIndex >= this.iterators.length) {
            return false;
        }
        return this.iterators[this.iteratorIndex].hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterators[this.iteratorIndex].next();
    }
}

