/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java;

import ch.obermuhlner.scriptengine.java.MemoryClassLoader;
import ch.obermuhlner.scriptengine.java.util.CompositeIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public class MemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<String, ClassMemoryJavaFileObject> mapNameToClasses = new HashMap<String, ClassMemoryJavaFileObject>();
    private final ClassLoader parentClassLoader;

    public MemoryFileManager(JavaFileManager fileManager, ClassLoader parentClassLoader) {
        super(fileManager);
        this.parentClassLoader = parentClassLoader;
    }

    private Collection<ClassMemoryJavaFileObject> memoryClasses() {
        return this.mapNameToClasses.values();
    }

    public JavaFileObject createSourceFileObject(Object origin, String name, String code) {
        return new MemoryJavaFileObject(origin, name, JavaFileObject.Kind.SOURCE, code);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        ClassLoader classLoader = super.getClassLoader(location);
        if (location == StandardLocation.CLASS_OUTPUT) {
            if (this.parentClassLoader != null) {
                classLoader = this.parentClassLoader;
            }
            HashMap<String, byte[]> mapNameToBytes = new HashMap<String, byte[]>();
            for (ClassMemoryJavaFileObject outputMemoryJavaFileObject : this.memoryClasses()) {
                mapNameToBytes.put(outputMemoryJavaFileObject.getName(), outputMemoryJavaFileObject.getBytes());
            }
            return new MemoryClassLoader(mapNameToBytes, classLoader);
        }
        return classLoader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> list = super.list(location, packageName, kinds, recurse);
        if (location == StandardLocation.CLASS_OUTPUT) {
            Collection<ClassMemoryJavaFileObject> generatedClasses = this.memoryClasses();
            return () -> new CompositeIterator(list.iterator(), generatedClasses.iterator());
        }
        return list;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof ClassMemoryJavaFileObject) {
            return file.getName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            ClassMemoryJavaFileObject file = new ClassMemoryJavaFileObject(className);
            this.mapNameToClasses.put(className, file);
            return file;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    static class ClassMemoryJavaFileObject
    extends AbstractMemoryJavaFileObject {
        private ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        private transient byte[] bytes = null;
        private final String className;

        public ClassMemoryJavaFileObject(String className) {
            super(className, JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = this.byteOutputStream.toByteArray();
                this.byteOutputStream = null;
            }
            return this.bytes;
        }

        @Override
        public String getName() {
            return this.className;
        }

        @Override
        public OutputStream openOutputStream() {
            return this.byteOutputStream;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.getBytes());
        }
    }

    static class MemoryJavaFileObject
    extends AbstractMemoryJavaFileObject {
        private final Object origin;
        private final String code;

        MemoryJavaFileObject(Object origin, String className, JavaFileObject.Kind kind, String code) {
            super(className, kind);
            this.origin = origin;
            this.code = code;
        }

        public Object getOrigin() {
            return this.origin;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    static abstract class AbstractMemoryJavaFileObject
    extends SimpleJavaFileObject {
        public AbstractMemoryJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("memory:///" + name.replace('.', '/') + kind.extension), kind);
        }
    }
}

