/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Map;

public class MemoryClassLoader
extends ClassLoader {
    public static final String MEMORY_CLASS_URL = "jrt:/ch.obermuhlner.scriptengine.java/memory-class";
    private ProtectionDomain protectionDomain;
    private Map<String, byte[]> mapClassBytes;

    public MemoryClassLoader(Map<String, byte[]> mapClassBytes, ClassLoader parent) {
        super(parent);
        this.mapClassBytes = mapClassBytes;
        try {
            URL url = new URL(MEMORY_CLASS_URL);
            CodeSource codeSource = new CodeSource(url, (Certificate[])null);
            this.protectionDomain = new ProtectionDomain(codeSource, null, this, new Principal[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.mapClassBytes.get(name);
        if (bytes == null) {
            return super.loadClass(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length, this.protectionDomain);
    }
}

