/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java.execution;

import ch.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import ch.obermuhlner.scriptengine.java.internal.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.script.ScriptException;

public class MethodExecutionStrategy
implements ExecutionStrategy {
    private Method method;
    private Object[] arguments;

    private MethodExecutionStrategy(Method method, Object ... arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    @Override
    public Object execute(Object instance) throws ScriptException {
        try {
            return this.method.invoke(instance, this.arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ScriptException(e);
        }
    }

    public static MethodExecutionStrategy byMethod(Method method, Object ... arguments) {
        return new MethodExecutionStrategy(method, arguments);
    }

    public static MethodExecutionStrategy byArgumentTypes(Class<?> clazz, String methodName, Class<?>[] argumentTypes, Object ... arguments) throws ScriptException {
        try {
            Method method = clazz.getMethod(methodName, argumentTypes);
            return MethodExecutionStrategy.byMethod(method, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptException(e);
        }
    }

    public static MethodExecutionStrategy byMatchingArguments(Class<?> clazz, String methodName, Object ... arguments) throws ScriptException {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if ((method.getModifiers() & 1) == 0 || !ReflectionUtil.matchesArguments(method, arguments)) continue;
            matchingMethods.add(method);
        }
        if (matchingMethods.size() == 0) {
            throw new ScriptException("No method '" + methodName + "' with matching arguments found");
        }
        if (matchingMethods.size() > 1) {
            throw new ScriptException("Ambiguous methods '" + methodName + "' with matching arguments found: " + matchingMethods.size());
        }
        return MethodExecutionStrategy.byMethod((Method)matchingMethods.get(0), arguments);
    }
}

