/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java.constructor;

import ch.obermuhlner.scriptengine.java.constructor.ConstructorStrategy;
import ch.obermuhlner.scriptengine.java.internal.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.script.ScriptException;

public class DefaultConstructorStrategy
implements ConstructorStrategy {
    private Class<?>[] argumentTypes;
    private final Object[] arguments;

    private DefaultConstructorStrategy(Class<?>[] argumentTypes, Object[] arguments) {
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
    }

    @Override
    public Object construct(Class<?> clazz) throws ScriptException {
        try {
            Constructor<?> constructor = this.findConstructor(clazz, this.argumentTypes, this.arguments);
            return constructor.newInstance(this.arguments);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ScriptException(e);
        }
    }

    public static DefaultConstructorStrategy byDefaultConstructor() {
        return new DefaultConstructorStrategy(new Class[0], new Object[0]);
    }

    public static DefaultConstructorStrategy byArgumentTypes(Class<?>[] argumentTypes, Object ... arguments) {
        return new DefaultConstructorStrategy(argumentTypes, arguments);
    }

    public static DefaultConstructorStrategy byMatchingArguments(Object ... arguments) {
        return new DefaultConstructorStrategy(null, arguments);
    }

    private Constructor<?> findConstructor(Class<?> clazz, Class<?>[] argumentTypes, Object[] arguments) throws NoSuchMethodException, ScriptException {
        if (argumentTypes != null) {
            return clazz.getConstructor(argumentTypes);
        }
        ArrayList matchingConstructors = new ArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || !ReflectionUtil.matchesArguments(constructor, arguments)) continue;
            matchingConstructors.add(constructor);
        }
        if (matchingConstructors.size() == 0) {
            throw new ScriptException("No constructor with matching arguments found");
        }
        if (matchingConstructors.size() > 1) {
            throw new ScriptException("Ambiguous constructors with matching arguments found: " + matchingConstructors.size());
        }
        return (Constructor)matchingConstructors.get(0);
    }
}

