/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.Bundler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;

public class Watch {
    private final Process process;
    private final Path workingFolder;
    private final Bundler.BundleType type;

    public Watch(Process process, Path workingFolder, Bundler.BundleType type) {
        this.process = process;
        this.workingFolder = workingFolder;
        this.type = type;
    }

    public void stop() {
        this.process.destroy();
    }

    public void change(List<Path> dependencies, List<Path> entries) throws IOException {
        Bundler.extract(this.workingFolder, dependencies, this.type);
        this.change(entries);
    }

    public void change(List<Path> entries) {
        entries.stream().map(script -> {
            try {
                return Files.copy(script, this.workingFolder.resolve(script.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

