/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.TemplateNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class EvalSectionHelper
implements SectionHelper {
    private static final String TEMPLATE = "template";
    private final Map<String, Expression> parameters;
    private final Engine engine;

    public EvalSectionHelper(Map<String, Expression> parameters, Engine engine) {
        this.parameters = parameters;
        this.engine = engine;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                try {
                    TemplateImpl template;
                    String templateStr = evaluatedParams.get(TEMPLATE).toString();
                    try {
                        template = (TemplateImpl)this.engine.parse(templateStr);
                    }
                    catch (TemplateException e) {
                        TemplateNode.Origin origin = this.parameters.get(TEMPLATE).getOrigin();
                        throw TemplateException.builder().message("Parser error in the evaluated template: {templateId} line {line}:\\n\\t{originalMessage}").code(Code.ERROR_IN_EVALUATED_TEMPLATE).argument("templateId", origin.hasNonGeneratedTemplateId() ? " template [" + origin.getTemplateId() + "]" : "").argument("line", origin.getLine()).argument("originalMessage", e.getMessage()).build();
                    }
                    template.root.resolve(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    static enum Code implements ErrorCode
    {
        ERROR_IN_EVALUATED_TEMPLATE;


        @Override
        public String getName() {
            return "EVAL_" + this.name();
        }
    }

    public static class Factory
    implements SectionHelperFactory<EvalSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("eval");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(EvalSectionHelper.TEMPLATE).build();
        }

        @Override
        public EvalSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                params.put(entry.getKey(), context.getExpression(entry.getKey()));
            }
            return new EvalSectionHelper(params, context.getEngine());
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    block.addExpression(entry.getKey(), entry.getValue());
                }
            }
            return outerScope;
        }
    }
}

