/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import ch.nerdin.esbuild.util.QuteTemplateRenderer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ImportToPackage {
    private static final String MVNPM_PACKAGE_PREFIX = "resources/_static";
    private static final String IMPORT_FILE_NAME = "META-INF/importmap.json";

    protected static String convert(String name, String version, String main) {
        return QuteTemplateRenderer.render("package-template.json", Map.of("name", name, "version", version, "main", main));
    }

    protected static String[] extractInfo(Path importMapFile) {
        try {
            JSONTokener jsonTokener = new JSONTokener((InputStream)new FileInputStream(importMapFile.toFile()));
            JSONObject object = new JSONObject(jsonTokener);
            JSONObject imports = object.getJSONObject("imports");
            Iterator keys = imports.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = imports.getString(key);
                if (!value.contains(".js")) continue;
                return new String[]{key, value};
            }
            throw new RuntimeException("could not find script in import map");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createPackage(Path location, String moduleName, String version) throws IOException {
        Path importMapFile = location.resolve(IMPORT_FILE_NAME);
        String[] result = ImportToPackage.extractInfo(importMapFile);
        String name = result[0];
        String packageContents = ImportToPackage.convert(name, version, result[1].substring(result[1].indexOf(name) + name.length() + 1));
        Path modulePath = importMapFile.getParent().resolve(MVNPM_PACKAGE_PREFIX).resolve(moduleName);
        Path packageFile = modulePath.resolve("package.json");
        Files.writeString(packageFile, (CharSequence)packageContents, new OpenOption[0]);
        Path nodeModules = location.resolve("node_modules").resolve(name);
        File parent = nodeModules.getParent().toFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Files.move(packageFile.getParent(), nodeModules, new CopyOption[0]);
    }
}

