/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BundleOptions;
import ch.nerdin.esbuild.EsBuildConfig;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.EntryPoint;
import ch.nerdin.esbuild.util.ImportToPackage;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class Bundler {
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    public static final String ESBUILD_VERSION = "0.17.10";

    public static Path bundle(BundleOptions bundleOptions) throws IOException {
        Path location = Bundler.createWorkingTempFolder(bundleOptions.getDependencies(), bundleOptions.getType(), bundleOptions.getEntries());
        Path dist = location.resolve("dist");
        Path entry = Bundler.createOneEntryPointScript(bundleOptions.getBundleName(), bundleOptions.getEntries(), location);
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        esBuildConfig.setOutDir(dist.toString());
        esBuildConfig.setEntryPoint(entry.toFile().toString());
        Bundler.esBuild(esBuildConfig);
        return dist;
    }

    private static Path createOneEntryPointScript(String bundleName, List<Path> entries, Path location) throws IOException {
        String entryString = EntryPoint.convert(entries.stream().map(Path::toFile).collect(Collectors.toList()));
        Path entry = location.resolve("%s.js".formatted(bundleName));
        Files.writeString(entry, (CharSequence)entryString, new OpenOption[0]);
        return entry;
    }

    private static Path createWorkingTempFolder(List<Path> dependencies, BundleType type, List<Path> entries) throws IOException {
        Path location = Bundler.extract(dependencies, type);
        for (Path entry : entries) {
            Bundler.copy(entry, location);
        }
        return location;
    }

    private static void copy(Path entry, Path location) throws IOException {
        Path target = location.resolve(entry.getFileName());
        Files.copy(entry, target, StandardCopyOption.REPLACE_EXISTING);
    }

    protected static Path extract(List<Path> dependencies, BundleType type) throws IOException {
        Path bundleDirectory = Files.createTempDirectory("bundle", new FileAttribute[0]);
        Path nodeModules = bundleDirectory.resolve("node_modules");
        nodeModules.toFile().mkdir();
        for (Path path : dependencies) {
            UnZip.unzip(path, bundleDirectory);
            NameVersion nameVersion = Bundler.parseName(path.getFileName().toString());
            switch (type) {
                case MVNPM: {
                    ImportToPackage.createPackage(bundleDirectory, nameVersion.name, nameVersion.version);
                    break;
                }
                case WEBJARS: {
                    Files.move(bundleDirectory.resolve(WEBJAR_PACKAGE_PREFIX).resolve(nameVersion.name).resolve(nameVersion.version), nodeModules.resolve(nameVersion.name), new CopyOption[0]);
                }
            }
        }
        return bundleDirectory;
    }

    protected static void esBuild(EsBuildConfig esBuildConfig) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_VERSION);
        new Execute(esBuildExec.toFile(), esBuildConfig).execute();
    }

    private static NameVersion parseName(String fileName) {
        int separatorIndex = fileName.lastIndexOf("-");
        String name = fileName.substring(0, separatorIndex);
        String version = fileName.substring(separatorIndex + 1, fileName.lastIndexOf(46));
        return new NameVersion(name, version);
    }

    public static enum BundleType {
        WEBJARS,
        MVNPM;

    }

    static class NameVersion {
        public String name;
        public String version;

        public NameVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

