/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.resolve;

import ch.nerdin.esbuild.resolve.BaseResolver;
import ch.nerdin.esbuild.resolve.Resolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class CacheResolver
extends BaseResolver
implements Resolver {
    public CacheResolver(Resolver resolver) {
        super(resolver);
    }

    @Override
    public Path resolve(String version) throws IOException {
        Path path;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File[] matchingFiles = tmpdir.listFiles((dir, name) -> name.startsWith("esbuild-" + version));
        if (matchingFiles != null && matchingFiles.length != 0 && (path = matchingFiles[0].toPath().resolve("package/bin/esbuild")).toFile().exists()) {
            return path;
        }
        return this.resolver.resolve(version);
    }
}

