/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class HttpServletResponseWrapper
implements HttpResponse {
    protected final HttpServletResponse response;
    protected int status = 200;
    protected MultivaluedMap<String, Object> outputHeaders;
    protected final ResteasyProviderFactory factory;
    private OutputStream outputStream;
    protected volatile boolean suppressExceptionDuringChunkedTransfer = true;
    protected final HttpServletRequest request;
    protected final Map<Class<?>, Object> contextDataMap;

    @Override
    public void setSuppressExceptionDuringChunkedTransfer(boolean suppressExceptionDuringChunkedTransfer) {
        this.suppressExceptionDuringChunkedTransfer = suppressExceptionDuringChunkedTransfer;
    }

    @Override
    public boolean suppressExceptionDuringChunkedTransfer() {
        return this.suppressExceptionDuringChunkedTransfer;
    }

    public HttpServletResponseWrapper(HttpServletResponse response, HttpServletRequest request, ResteasyProviderFactory factory) {
        this.response = response;
        this.request = request;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new DeferredOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public synchronized void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add("Set-Cookie", cookie);
    }

    @Override
    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    private static class AsyncOperationComparator
    implements Comparator<AsyncOperation> {
        static final AsyncOperationComparator INSTANCE = new AsyncOperationComparator();

        private AsyncOperationComparator() {
        }

        @Override
        public int compare(AsyncOperation o1, AsyncOperation o2) {
            return Long.compare(o1.id, o2.id);
        }
    }

    protected class DeferredOutputStream
    extends AsyncOutputStream
    implements WriteListener {
        private final Queue<AsyncOperation> asyncQueue = new PriorityQueue<AsyncOperation>(AsyncOperationComparator.INSTANCE);
        private final AtomicBoolean asyncRegistered = new AtomicBoolean();
        private volatile boolean asyncListenerCalled;
        private volatile ServletOutputStream lazyOut;
        private long idCounter;

        DeferredOutputStream() throws IOException {
        }

        @Override
        public void write(int i) throws IOException {
            this.getServletOutputStream().write(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.getServletOutputStream().write(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            this.getServletOutputStream().write(bytes, i, i1);
        }

        @Override
        public void flush() throws IOException {
            this.getServletOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public CompletionStage<Void> asyncFlush() {
            FlushOperation op = new FlushOperation(this);
            this.queue(op);
            return op.future;
        }

        @Override
        public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
            WriteOperation op = new WriteOperation(this, bytes, offset, length);
            this.queue(op);
            return op.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(AsyncOperation op) {
            HttpRequest resteasyRequest = (HttpRequest)HttpServletResponseWrapper.this.contextDataMap.get(HttpRequest.class);
            if (HttpServletResponseWrapper.this.request.isAsyncStarted() && !resteasyRequest.getAsyncContext().isOnInitialRequest()) {
                ServletOutputStream out;
                boolean flush = false;
                try {
                    out = this.getServletOutputStream();
                }
                catch (IOException e) {
                    op.future.completeExceptionally(e);
                    return;
                }
                if (this.asyncRegistered.compareAndSet(false, true)) {
                    out.setWriteListener((WriteListener)this);
                }
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    if (this.asyncListenerCalled && out.isReady()) {
                        this.asyncQueue.add(op);
                        flush = true;
                    } else {
                        this.asyncQueue.add(op);
                    }
                }
                if (flush) {
                    this.flushQueue();
                }
            } else {
                op.work(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushQueue() {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                AsyncOperation op;
                ServletOutputStream out;
                try {
                    out = this.getServletOutputStream();
                }
                catch (IOException e) {
                    this.onError(e);
                    return;
                }
                while (out.isReady() && (op = this.asyncQueue.poll()) != null) {
                    op.work(out);
                }
            }
        }

        public void onWritePossible() {
            this.asyncListenerCalled = true;
            this.flushQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                AsyncOperation op;
                this.asyncListenerCalled = true;
                while ((op = this.asyncQueue.poll()) != null) {
                    if (op.future.isDone()) continue;
                    op.future.completeExceptionally(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServletOutputStream getServletOutputStream() throws IOException {
            if (this.lazyOut == null) {
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    if (this.lazyOut == null) {
                        this.lazyOut = HttpServletResponseWrapper.this.response.getOutputStream();
                    }
                }
            }
            return this.lazyOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getId() {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                if (this.idCounter == Long.MAX_VALUE) {
                    this.idCounter = 0L;
                }
                return this.idCounter++;
            }
        }
    }

    private class CompletionOperation
    extends AsyncOperation {
        CompletionOperation(AsyncOperation op) {
            super(op.stream, op.future, op.id);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            if (sos == null || sos.isReady()) {
                if (!this.future.isDone()) {
                    this.future.complete(null);
                }
            } else {
                this.queueComplete(this);
            }
        }
    }

    public class FlushOperation
    extends AsyncOperation {
        @Deprecated
        public FlushOperation(OutputStream os) {
            super(os);
        }

        public FlushOperation(DeferredOutputStream os) {
            super(os);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null) {
                    this.stream.flush();
                    this.future.complete(null);
                } else if (sos.isReady()) {
                    this.stream.flush();
                    if (sos.isReady()) {
                        this.future.complete(null);
                    } else {
                        this.queueComplete(this);
                    }
                } else {
                    this.requeue(this);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[flush]";
        }
    }

    public class WriteOperation
    extends AsyncOperation {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        @Deprecated
        public WriteOperation(OutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        private WriteOperation(DeferredOutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null) {
                    this.stream.write(this.bytes, this.offset, this.length);
                    this.future.complete(null);
                } else if (sos.isReady()) {
                    this.stream.write(this.bytes, this.offset, this.length);
                    if (sos.isReady()) {
                        this.future.complete(null);
                    } else {
                        this.queueComplete(this);
                    }
                } else {
                    this.requeue(this);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[write: " + new String(this.bytes) + "]";
        }
    }

    public abstract class AsyncOperation {
        final CompletableFuture<Void> future;
        final OutputStream stream;
        private final long id;

        @Deprecated
        public AsyncOperation(OutputStream stream) {
            this(stream, new CompletableFuture<Void>(), stream instanceof DeferredOutputStream ? ((DeferredOutputStream)stream).getId() : -1L);
        }

        private AsyncOperation(DeferredOutputStream stream) {
            this(stream, new CompletableFuture<Void>(), stream.getId());
        }

        private AsyncOperation(OutputStream stream, CompletableFuture<Void> future, long id) {
            this.stream = stream;
            this.future = future;
            this.id = id;
        }

        public void work(ServletOutputStream sos) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(HttpServletResponseWrapper.this.contextDataMap);){
                this.doWork(sos);
            }
        }

        protected abstract void doWork(ServletOutputStream var1);

        protected void requeue(AsyncOperation op) {
            if (op.future.isDone()) {
                return;
            }
            if (this.stream instanceof DeferredOutputStream) {
                ((DeferredOutputStream)this.stream).queue(op);
            }
        }

        protected void queueComplete(AsyncOperation op) {
            if (op.future.isDone()) {
                return;
            }
            if (this.stream instanceof DeferredOutputStream) {
                AsyncOperation requeue = op instanceof CompletionOperation ? op : new CompletionOperation(op);
                ((DeferredOutputStream)this.stream).queue(requeue);
            }
        }
    }
}

