/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.SimpleViolationsContainer;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.validation.ConstraintTypeUtil;

public abstract class ResteasyViolationException
extends ConstraintViolationException {
    private static final long serialVersionUID = 2623733139912277260L;
    public static final String SUPPRESS_VIOLATION_PATH = "resteasy.validation.suppress.path";
    private volatile List<CloneableMediaType> accept;
    private volatile Exception exception;
    private final List<ResteasyConstraintViolation> propertyViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
    private final List<ResteasyConstraintViolation> classViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
    private final List<ResteasyConstraintViolation> parameterViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
    private final List<ResteasyConstraintViolation> returnValueViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
    private final List<ResteasyConstraintViolation> allViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
    private final List<List<ResteasyConstraintViolation>> violationLists = new CopyOnWriteArrayList<List<ResteasyConstraintViolation>>();
    private transient ConstraintTypeUtil util = this.getConstraintTypeUtil();
    private boolean suppressPath;

    public ResteasyViolationException(Set<? extends ConstraintViolation<?>> constraintViolations) {
        super(constraintViolations);
        this.checkSuppressPath();
        this.accept = new ArrayList<CloneableMediaType>();
        this.accept.add(CloneableMediaType.TEXT_PLAIN_TYPE);
        this.convertViolations();
    }

    public ResteasyViolationException(Set<? extends ConstraintViolation<?>> constraintViolations, List<MediaType> accept) {
        super(constraintViolations);
        this.checkSuppressPath();
        this.accept = ResteasyViolationException.toCloneableMediaTypeList(accept);
        this.convertViolations();
    }

    public ResteasyViolationException(SimpleViolationsContainer container) {
        this(container.getViolations());
        this.setException(container.getException());
    }

    public ResteasyViolationException(SimpleViolationsContainer container, List<MediaType> accept) {
        this(container.getViolations(), accept);
        this.setException(container.getException());
    }

    public ResteasyViolationException(String stringRep) {
        super((Set<? extends ConstraintViolation<?>>)null);
        this.checkSuppressPath();
        this.convertFromString(stringRep);
    }

    public abstract ConstraintTypeUtil getConstraintTypeUtil();

    public List<MediaType> getAccept() {
        return ResteasyViolationException.toMediaTypeList(this.accept);
    }

    public void setAccept(List<MediaType> accept) {
        this.accept = ResteasyViolationException.toCloneableMediaTypeList(accept);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.initCause(exception);
    }

    public List<ResteasyConstraintViolation> getViolations() {
        return this.allViolations;
    }

    public List<ResteasyConstraintViolation> getPropertyViolations() {
        return this.propertyViolations;
    }

    public List<ResteasyConstraintViolation> getClassViolations() {
        return this.classViolations;
    }

    public List<ResteasyConstraintViolation> getParameterViolations() {
        return this.parameterViolations;
    }

    public List<ResteasyConstraintViolation> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public int size() {
        return this.getViolations().size();
    }

    public List<List<ResteasyConstraintViolation>> getViolationLists() {
        return this.violationLists;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (List<ResteasyConstraintViolation> violations : this.violationLists) {
            for (ResteasyConstraintViolation violation : violations) {
                sb.append(violation.toString()).append('\r');
            }
        }
        return sb.toString();
    }

    protected void convertFromString(String stringRep) {
        ByteArrayInputStream is = new ByteArrayInputStream(stringRep.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line = br.readLine();
            while (line != null) {
                ConstraintType.Type type = ConstraintType.Type.valueOf(line.substring(1, line.length() - 1));
                line = br.readLine();
                String path = line.substring(1, line.length() - 1);
                line = br.readLine();
                String message = line.substring(1, line.length() - 1);
                line = br.readLine();
                String value = line.substring(1, line.length() - 1);
                ResteasyConstraintViolation rcv = new ResteasyConstraintViolation(type, path, message, value);
                switch (type) {
                    case PROPERTY: {
                        this.propertyViolations.add(rcv);
                        break;
                    }
                    case CLASS: {
                        this.classViolations.add(rcv);
                        break;
                    }
                    case PARAMETER: {
                        this.parameterViolations.add(rcv);
                        break;
                    }
                    case RETURN_VALUE: {
                        this.returnValueViolations.add(rcv);
                        break;
                    }
                    default: {
                        throw new RuntimeException(Messages.MESSAGES.unexpectedViolationType(type));
                    }
                }
                this.allViolations.add(rcv);
                line = br.readLine();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.MESSAGES.unableToParseException());
        }
        this.violationLists.clear();
        this.violationLists.add(this.propertyViolations);
        this.violationLists.add(this.classViolations);
        this.violationLists.add(this.parameterViolations);
        this.violationLists.add(this.returnValueViolations);
    }

    protected int getField(int start, String line) {
        int beginning = line.indexOf(91, start);
        if (beginning == -1) {
            throw new RuntimeException(Messages.MESSAGES.exceptionHasInvalidFormat(line));
        }
        int index = beginning;
        int bracketCount = 1;
        while (++index < line.length()) {
            char c = line.charAt(index);
            if (c == '[') {
                ++bracketCount;
            } else if (c == ']') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            break;
        }
        if (bracketCount != 0) {
            throw new RuntimeException(Messages.MESSAGES.exceptionHasInvalidFormat(line));
        }
        return index;
    }

    protected abstract ResteasyConfiguration getResteasyConfiguration();

    protected void checkSuppressPath() {
        String s;
        ResteasyConfiguration context = this.getResteasyConfiguration();
        if (context != null && (s = context.getParameter(SUPPRESS_VIOLATION_PATH)) != null) {
            this.suppressPath = Boolean.parseBoolean(s);
        }
    }

    protected void convertViolations() {
        if (!this.violationLists.isEmpty()) {
            return;
        }
        if (this.getConstraintViolations() != null) {
            Iterator<ConstraintViolation<?>> it = this.getConstraintViolations().iterator();
            while (it.hasNext()) {
                ResteasyConstraintViolation rcv = this.convertViolation(it.next());
                switch (rcv.getConstraintType()) {
                    case PROPERTY: {
                        this.propertyViolations.add(rcv);
                        break;
                    }
                    case CLASS: {
                        this.classViolations.add(rcv);
                        break;
                    }
                    case PARAMETER: {
                        this.parameterViolations.add(rcv);
                        break;
                    }
                    case RETURN_VALUE: {
                        this.returnValueViolations.add(rcv);
                        break;
                    }
                    default: {
                        throw new RuntimeException(Messages.MESSAGES.unexpectedViolationType(rcv.getConstraintType()));
                    }
                }
                this.allViolations.add(rcv);
            }
        }
        this.violationLists.add(this.propertyViolations);
        this.violationLists.add(this.classViolations);
        this.violationLists.add(this.parameterViolations);
        this.violationLists.add(this.returnValueViolations);
    }

    protected ResteasyConstraintViolation convertViolation(ConstraintViolation<?> violation) {
        ConstraintType.Type ct = this.util.getConstraintType(violation);
        String path = this.suppressPath ? "*" : violation.getPropertyPath().toString();
        return new ResteasyConstraintViolation(ct, path, violation.getMessage(), ResteasyViolationException.convertArrayToString(violation.getInvalidValue()));
    }

    protected static String convertArrayToString(Object o) {
        String result = null;
        if (o instanceof Object[]) {
            Object[] array = (Object[])Object[].class.cast(o);
            if (array.length == 0) {
                return "[]";
            }
            StringBuffer sb = new StringBuffer("[").append(ResteasyViolationException.convertArrayToString(array[0]));
            for (int i = 1; i < array.length; ++i) {
                sb.append(", ").append(ResteasyViolationException.convertArrayToString(array[i]));
            }
            sb.append("]");
            result = sb.toString();
        } else {
            result = o == null ? "" : o.toString();
        }
        return result;
    }

    protected static List<CloneableMediaType> toCloneableMediaTypeList(List<MediaType> list) {
        ArrayList<CloneableMediaType> cloneableList = new ArrayList<CloneableMediaType>();
        Iterator<MediaType> it = list.iterator();
        while (it.hasNext()) {
            cloneableList.add(new CloneableMediaType(it.next()));
        }
        return cloneableList;
    }

    protected static List<MediaType> toMediaTypeList(List<CloneableMediaType> cloneableList) {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (CloneableMediaType cmt : cloneableList) {
            list.add(new MediaType(cmt.type, cmt.subtype, cmt.parameters));
        }
        return list;
    }

    static class CloneableMediaType
    implements Serializable {
        public static final CloneableMediaType TEXT_PLAIN_TYPE = new CloneableMediaType("plain", "text");
        private static final long serialVersionUID = 9179565449557464429L;
        private String type;
        private String subtype;
        private Map<String, String> parameters;

        CloneableMediaType(MediaType mediaType) {
            this.type = mediaType.getType();
            this.subtype = mediaType.getSubtype();
            this.parameters = new HashMap<String, String>(mediaType.getParameters());
        }

        CloneableMediaType(String type, String subtype) {
            this.type = type;
            this.subtype = subtype;
        }

        public MediaType toMediaType() {
            return new MediaType(this.type, this.subtype, this.parameters);
        }
    }
}

