/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.eventbus;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.mutiny.core.MultiMap;

@MutinyGen(value=io.vertx.core.eventbus.Message.class)
public class Message<T> {
    public static final TypeArg<Message> __TYPE_ARG = new TypeArg<Message>(obj -> new Message((io.vertx.core.eventbus.Message)obj), Message::getDelegate);
    private final io.vertx.core.eventbus.Message<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private T cached_0;

    public Message(io.vertx.core.eventbus.Message delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public Message(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.core.eventbus.Message)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public Message(io.vertx.core.eventbus.Message delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    Message() {
        this.delegate = null;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public io.vertx.core.eventbus.Message getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message that = (Message)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public T body() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        T ret = this.__typeArg_0.wrap(this.delegate.body());
        this.cached_0 = ret;
        return ret;
    }

    public String replyAddress() {
        String ret = this.delegate.replyAddress();
        return ret;
    }

    public boolean isSend() {
        boolean ret = this.delegate.isSend();
        return ret;
    }

    public void reply(Object message) {
        this.delegate.reply(message);
    }

    public void reply(Object message, DeliveryOptions options) {
        this.delegate.reply(message, options);
    }

    @CheckReturnValue
    public <R> Uni<Message<R>> replyAndRequest(Object message) {
        return AsyncResultUni.toUni(replyHandler -> this.delegate.replyAndRequest(message, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown())))));
    }

    public <R> Message<R> replyAndRequestAndAwait(Object message) {
        return this.replyAndRequest(message).await().indefinitely();
    }

    public <R> void replyAndRequestAndForget(Object message) {
        this.replyAndRequest(message).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <R> Uni<Message<R>> replyAndRequest(Object message, DeliveryOptions options) {
        return AsyncResultUni.toUni(replyHandler -> this.delegate.replyAndRequest(message, options, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown())))));
    }

    public <R> Message<R> replyAndRequestAndAwait(Object message, DeliveryOptions options) {
        return this.replyAndRequest(message, options).await().indefinitely();
    }

    public <R> void replyAndRequestAndForget(Object message, DeliveryOptions options) {
        this.replyAndRequest(message, options).subscribe().with(UniHelper.NOOP);
    }

    public void fail(int failureCode, String message) {
        this.delegate.fail(failureCode, message);
    }

    public static <T> Message<T> newInstance(io.vertx.core.eventbus.Message arg) {
        return arg != null ? new Message<T>(arg) : null;
    }

    public static <T> Message<T> newInstance(io.vertx.core.eventbus.Message arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new Message<T>(arg, __typeArg_T) : null;
    }
}

