/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.io.jar;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFiles {
    public static JarFile create(String name) throws IOException {
        return new JarFile(name);
    }

    public static JarFile create(String name, boolean verify) throws IOException {
        return new JarFile(name, verify);
    }

    public static JarFile create(File file) throws IOException {
        return new JarFile(file);
    }

    public static JarFile create(File file, boolean verify) throws IOException {
        return new JarFile(file, verify);
    }

    public static boolean isMultiRelease(JarFile jarFile) {
        String value = null;
        try {
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                value = manifest.getMainAttributes().getValue("Multi-Release");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read manifest attributes", e);
        }
        return Boolean.parseBoolean(value);
    }
}

