/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.classloader;

import io.smallrye.common.classloader.DefineClassPermission;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import sun.misc.Unsafe;

public class ClassDefiner {
    private static final Unsafe unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    });
    private static final Method defineClass = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                return Unsafe.class.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }
    });

    public static Class<?> defineClass(MethodHandles.Lookup lookup, Class<?> parent, String className, byte[] classBytes) {
        String classPkg;
        String parentPkg;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(DefineClassPermission.getInstance());
        }
        if (!(parentPkg = parent.getPackage().getName()).equals(classPkg = className.substring(0, className.lastIndexOf(46)))) {
            throw new IllegalArgumentException("Class not in same package as lookup class");
        }
        try {
            return (Class)defineClass.invoke((Object)unsafe, className, classBytes, 0, classBytes.length, parent.getClassLoader(), null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

