/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class HttpAuthorizer {
    private static final Logger log = Logger.getLogger(HttpAuthorizer.class);
    private final HttpAuthenticator httpAuthenticator;
    private final IdentityProviderManager identityProviderManager;
    private final AuthorizationController controller;
    private final List<HttpSecurityPolicy> policies;
    private static final HttpSecurityPolicy.AuthorizationRequestContext CONTEXT = new HttpSecurityPolicy.AuthorizationRequestContext(){

        @Override
        public Uni<HttpSecurityPolicy.CheckResult> runBlocking(final RoutingContext context, final Uni<SecurityIdentity> identity, final BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> function) {
            if (BlockingOperationControl.isBlockingAllowed()) {
                try {
                    HttpSecurityPolicy.CheckResult res = function.apply(context, identity.await().indefinitely());
                    return Uni.createFrom().item(res);
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
            try {
                return Uni.createFrom().emitter(new Consumer<UniEmitter<? super HttpSecurityPolicy.CheckResult>>(){

                    @Override
                    public void accept(final UniEmitter<? super HttpSecurityPolicy.CheckResult> uniEmitter) {
                        ExecutorRecorder.getCurrent().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HttpSecurityPolicy.CheckResult val = (HttpSecurityPolicy.CheckResult)function.apply(context, (SecurityIdentity)identity.await().indefinitely());
                                    uniEmitter.complete(val);
                                }
                                catch (Throwable t) {
                                    uniEmitter.fail(t);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                return Uni.createFrom().failure(e);
            }
        }
    };

    HttpAuthorizer(HttpAuthenticator httpAuthenticator, IdentityProviderManager identityProviderManager, AuthorizationController controller, Instance<HttpSecurityPolicy> installedPolicies) {
        this.httpAuthenticator = httpAuthenticator;
        this.identityProviderManager = identityProviderManager;
        this.controller = controller;
        this.policies = new ArrayList<HttpSecurityPolicy>();
        for (HttpSecurityPolicy i : installedPolicies) {
            this.policies.add(i);
        }
    }

    public void checkPermission(RoutingContext routingContext) {
        if (!this.controller.isAuthorizationEnabled()) {
            routingContext.next();
            return;
        }
        this.doPermissionCheck(routingContext, QuarkusHttpUser.getSecurityIdentity(routingContext, this.identityProviderManager), 0, null, this.policies);
    }

    private void doPermissionCheck(final RoutingContext routingContext, final Uni<SecurityIdentity> identity, final int index, final SecurityIdentity augmentedIdentity, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
            if (!(augmentedIdentity == null || augmentedIdentity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == augmentedIdentity)) {
                routingContext.setUser(new QuarkusHttpUser(augmentedIdentity));
                routingContext.put("io.quarkus.vertx.http.deferred-identity", Uni.createFrom().item(augmentedIdentity));
            }
            routingContext.next();
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, CONTEXT).subscribe().with(new Consumer<HttpSecurityPolicy.CheckResult>(){

            @Override
            public void accept(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    HttpAuthorizer.this.doDeny(identity, routingContext);
                } else if (checkResult.getAugmentedIdentity() != null) {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, Uni.createFrom().item(checkResult.getAugmentedIdentity()), index + 1, checkResult.getAugmentedIdentity(), permissionCheckers);
                } else {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, identity, index + 1, augmentedIdentity, permissionCheckers);
                }
            }
        }, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                if (!routingContext.response().ended() && !throwable.equals(routingContext.failure())) {
                    routingContext.fail(throwable);
                } else if (!(throwable instanceof AuthenticationFailedException)) {
                    log.error((Object)"Exception occurred during authorization", throwable);
                }
            }
        });
    }

    private void doDeny(Uni<SecurityIdentity> identity, final RoutingContext routingContext) {
        identity.subscribe().withSubscriber(new UniSubscriber<SecurityIdentity>(){

            @Override
            public void onSubscribe(UniSubscription subscription) {
            }

            @Override
            public void onItem(SecurityIdentity identity) {
                if (identity.isAnonymous()) {
                    HttpAuthorizer.this.httpAuthenticator.sendChallenge(routingContext).subscribe().withSubscriber(new UniSubscriber<Boolean>(){

                        @Override
                        public void onSubscribe(UniSubscription subscription) {
                        }

                        @Override
                        public void onItem(Boolean item) {
                            if (!routingContext.response().ended()) {
                                routingContext.response().end();
                            }
                        }

                        @Override
                        public void onFailure(Throwable failure) {
                            if (!routingContext.response().ended()) {
                                routingContext.fail(failure);
                            } else if (!(failure instanceof IOException)) {
                                log.error((Object)"Failed to send challenge", failure);
                            } else {
                                log.debug((Object)"Failed to send challenge", failure);
                            }
                        }
                    });
                } else {
                    routingContext.fail(new ForbiddenException());
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                routingContext.fail(failure);
            }
        });
    }
}

