/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.enterprise.inject.Instance;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class HttpAuthenticator {
    private static final Logger log = Logger.getLogger(HttpAuthenticator.class);
    private final IdentityProviderManager identityProviderManager;
    private final Instance<PathMatchingHttpSecurityPolicy> pathMatchingPolicy;
    private final HttpAuthenticationMechanism[] mechanisms;

    public HttpAuthenticator(IdentityProviderManager identityProviderManager, Instance<PathMatchingHttpSecurityPolicy> pathMatchingPolicy, Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, Instance<IdentityProvider<?>> providers) {
        this.identityProviderManager = identityProviderManager;
        this.pathMatchingPolicy = pathMatchingPolicy;
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : httpAuthenticationMechanism) {
            boolean found = false;
            for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
                for (IdentityProvider identityProvider : providers) {
                    if (!identityProvider.getRequestType().equals(mechType)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (!found && !mechanism.getCredentialTypes().isEmpty()) continue;
            mechanisms.add(mechanism);
        }
        if (mechanisms.isEmpty()) {
            this.mechanisms = new HttpAuthenticationMechanism[]{new NoAuthenticationMechanism()};
        } else {
            mechanisms.sort(new Comparator<HttpAuthenticationMechanism>(){

                @Override
                public int compare(HttpAuthenticationMechanism mech1, HttpAuthenticationMechanism mech2) {
                    return Integer.compare(mech2.getPriority(), mech1.getPriority());
                }
            });
            this.mechanisms = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
        }
    }

    IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        final String pathSpecificMechanism = this.pathMatchingPolicy.isResolvable() ? ((PathMatchingHttpSecurityPolicy)this.pathMatchingPolicy.get()).getAuthMechanismName(routingContext) : null;
        Uni<HttpAuthenticationMechanism> matchingMechUni = this.findBestCandidateMechanism(routingContext, pathSpecificMechanism);
        if (matchingMechUni == null) {
            return this.createSecurityIdentity(routingContext);
        }
        return matchingMechUni.onItem().transformToUni(new Function<HttpAuthenticationMechanism, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpAuthenticationMechanism mech) {
                if (mech != null) {
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
                if (pathSpecificMechanism != null) {
                    return Uni.createFrom().optional(Optional.empty());
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext);
            }
        });
    }

    private Uni<SecurityIdentity> createSecurityIdentity(final RoutingContext routingContext) {
        Uni<SecurityIdentity> result = this.mechanisms[0].authenticate(routingContext, this.identityProviderManager);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni(new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(SecurityIdentity data) {
                    if (data != null) {
                        return Uni.createFrom().item(data);
                    }
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
            });
        }
        return result;
    }

    public Uni<Boolean> sendChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (!routingContext.request().isEnded()) {
            routingContext.request().resume();
        }
        Uni<Boolean> result = null;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            result = matchingMech.sendChallenge(routingContext);
        }
        if (result == null) {
            result = this.mechanisms[0].sendChallenge(routingContext);
            for (int i = 1; i < this.mechanisms.length; ++i) {
                final HttpAuthenticationMechanism mech = this.mechanisms[i];
                result = result.onItem().transformToUni(new Function<Boolean, Uni<? extends Boolean>>(){

                    @Override
                    public Uni<? extends Boolean> apply(Boolean authDone) {
                        if (authDone.booleanValue()) {
                            return Uni.createFrom().item(authDone);
                        }
                        return mech.sendChallenge(routingContext);
                    }
                });
            }
        }
        return result.onItem().transformToUni(new Function<Boolean, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(Boolean authDone) {
                if (!authDone.booleanValue()) {
                    log.debug("Authentication has not been done, returning HTTP status 401");
                    routingContext.response().setStatusCode(401);
                    routingContext.response().end();
                }
                return Uni.createFrom().item(authDone);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            return matchingMech.getChallenge(routingContext);
        }
        Uni<ChallengeData> result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni(new Function<ChallengeData, Uni<? extends ChallengeData>>(){

                @Override
                public Uni<? extends ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return Uni.createFrom().item(data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    private Uni<HttpAuthenticationMechanism> findBestCandidateMechanism(final RoutingContext routingContext, final String pathSpecificMechanism) {
        Uni<HttpAuthenticationMechanism> result = null;
        if (pathSpecificMechanism != null) {
            result = this.getPathSpecificMechanism(0, routingContext, pathSpecificMechanism);
            int i = 1;
            while (i < this.mechanisms.length) {
                final int mechIndex = i++;
                result = result.onItem().transformToUni(new Function<HttpAuthenticationMechanism, Uni<? extends HttpAuthenticationMechanism>>(){

                    @Override
                    public Uni<? extends HttpAuthenticationMechanism> apply(HttpAuthenticationMechanism mech) {
                        if (mech != null) {
                            return Uni.createFrom().item(mech);
                        }
                        return HttpAuthenticator.this.getPathSpecificMechanism(mechIndex, routingContext, pathSpecificMechanism);
                    }
                });
            }
        }
        return result;
    }

    private Uni<HttpAuthenticationMechanism> getPathSpecificMechanism(final int index, final RoutingContext routingContext, final String pathSpecificMechanism) {
        return HttpAuthenticator.getCredentialTransport(this.mechanisms[index], routingContext).onItem().transform(new Function<HttpCredentialTransport, HttpAuthenticationMechanism>(){

            @Override
            public HttpAuthenticationMechanism apply(HttpCredentialTransport t) {
                if (t != null && t.getAuthenticationScheme().equalsIgnoreCase(pathSpecificMechanism)) {
                    routingContext.put(HttpAuthenticationMechanism.class.getName(), HttpAuthenticator.this.mechanisms[index]);
                    return HttpAuthenticator.this.mechanisms[index];
                }
                return null;
            }
        });
    }

    private static Uni<HttpCredentialTransport> getCredentialTransport(HttpAuthenticationMechanism mechanism, RoutingContext routingContext) {
        try {
            return mechanism.getCredentialTransport(routingContext);
        }
        catch (UnsupportedOperationException ex) {
            return Uni.createFrom().item(mechanism.getCredentialTransport());
        }
    }

    static class NoopCloseTask
    implements Runnable {
        static final NoopCloseTask INSTANCE = new NoopCloseTask();

        NoopCloseTask() {
        }

        @Override
        public void run() {
        }
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().optional(Optional.empty());
        }

        @Override
        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return Uni.createFrom().item(challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }

        @Override
        public HttpCredentialTransport getCredentialTransport() {
            return null;
        }
    }
}

