/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpServerRequestWrapper;

class ResumingRequestWrapper
extends HttpServerRequestWrapper {
    private boolean userSetState;

    ResumingRequestWrapper(HttpServerRequest request) {
        super((HttpServerRequestInternal)request);
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public HttpServerRequest pause() {
        this.userSetState = true;
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.userSetState = true;
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.userSetState = true;
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler((Handler)handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }
}

