/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.NonJaxRsClassMappings;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;

@Provider
@Priority(value=5001)
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";
    private static final Variant JSON_VARIANT = new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, null);
    private static final Variant HTML_VARIANT = new Variant(MediaType.TEXT_HTML_TYPE, (String)null, null);
    private static final List<Variant> VARIANTS = Arrays.asList(JSON_VARIANT, HTML_VARIANT);
    private static final ResourceDescriptionComparator RESOURCE_DESCRIPTION_COMPARATOR = new ResourceDescriptionComparator();
    private static final MethodDescriptionComparator METHOD_DESCRIPTION_COMPARATOR = new MethodDescriptionComparator();
    private static volatile String httpRoot = "";
    private static volatile List<String> servletMappings = Collections.emptyList();
    private static volatile Set<java.nio.file.Path> staticResourceRoots = Collections.emptySet();
    private static volatile List<AdditionalRouteDescription> additionalEndpoints = Collections.emptyList();
    private static volatile Map<String, NonJaxRsClassMappings> nonJaxRsClassNameToMethodPaths = Collections.emptyMap();
    private static volatile List<RouteDescription> reactiveRoutes = Collections.emptyList();
    private static final Logger LOG = Logger.getLogger(NotFoundExceptionMapper.class);
    @Context
    private Registry registry = null;
    @Context
    private HttpHeaders headers;

    public static void setHttpRoot(String rootPath) {
        httpRoot = rootPath;
    }

    @Override
    public Response toResponse(NotFoundException exception) {
        if (this.registry == null) {
            return this.respond();
        }
        Map bounded = null;
        if (this.registry instanceof ResourceMethodRegistry) {
            bounded = ((ResourceMethodRegistry)this.registry).getBounded();
        } else if (Proxy.isProxyClass(this.registry.getClass()) && this.registry.toString().startsWith(ResourceMethodRegistry.class.getName())) {
            try {
                bounded = (Map)Proxy.getInvocationHandler(this.registry).invoke(this.registry, ResourceMethodRegistry.class.getMethod("getBounded", new Class[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bounded == null) {
            return this.respond();
        }
        List<ResourceDescription> descriptions = ResourceDescription.fromBoundResourceInvokers(bounded.entrySet());
        return this.respond(descriptions);
    }

    private Response respond() {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status(Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "No resources discovered");
            return Response.status(Response.Status.NOT_FOUND).entity(sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    private Response respond(List<ResourceDescription> descriptions) {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status(Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            List<String> resources;
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "Resources overview");
            sb.resourcesStart("REST resources");
            for (ResourceDescription resourceDescription : descriptions) {
                sb.resourcePath(TemplateHtmlBuilder.adjustRoot(httpRoot, resourceDescription.basePath));
                for (MethodDescription method : resourceDescription.calls) {
                    sb.method(method.method, method.fullPath);
                    if (method.consumes != null) {
                        sb.consumes(method.consumes);
                    }
                    if (method.produces != null) {
                        sb.produces(method.produces);
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
            }
            if (descriptions.isEmpty()) {
                sb.noResourcesFound();
            }
            sb.resourcesEnd();
            if (!servletMappings.isEmpty()) {
                sb.resourcesStart("Servlet mappings");
                for (String string : servletMappings) {
                    sb.servletMapping(TemplateHtmlBuilder.adjustRoot(httpRoot, string));
                }
                sb.resourcesEnd();
            }
            if (!reactiveRoutes.isEmpty()) {
                sb.resourcesStart("Reactive Routes");
                sb.resourceStart();
                for (RouteDescription routeDescription : reactiveRoutes) {
                    sb.method(routeDescription.getHttpMethod(), routeDescription.getPath() != null ? routeDescription.getPath() : "/*");
                    sb.listItem(routeDescription.getJavaMethod());
                    if (routeDescription.getConsumes() != null) {
                        sb.consumes(routeDescription.getConsumes());
                    }
                    if (routeDescription.getProduces() != null) {
                        sb.produces(routeDescription.getProduces());
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
                sb.resourcesEnd();
            }
            if (!staticResourceRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
                sb.resourcesStart("Static resources");
                for (String staticResource : resources) {
                    sb.staticResourcePath(TemplateHtmlBuilder.adjustRoot(httpRoot, staticResource));
                }
                sb.resourcesEnd();
            }
            if (!additionalEndpoints.isEmpty()) {
                sb.resourcesStart("Additional endpoints");
                for (AdditionalRouteDescription additionalRouteDescription : additionalEndpoints) {
                    sb.staticResourcePath(additionalRouteDescription.getUri(), additionalRouteDescription.getDescription());
                }
                sb.resourcesEnd();
            }
            return Response.status(Response.Status.NOT_FOUND).entity(sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    private List<String> findRealResources() {
        final HashSet knownFiles = new HashSet();
        for (final java.nio.file.Path resource : staticResourceRoots) {
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            try {
                Stream<java.nio.file.Path> fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
                try {
                    fileTreeElements.forEach(new Consumer<java.nio.file.Path>(){

                        @Override
                        public void accept(java.nio.file.Path path) {
                            if (resource.equals(path)) {
                                return;
                            }
                            java.nio.file.Path rel = resource.relativize(path);
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                knownFiles.add(rel.toString());
                            }
                        }
                    });
                }
                finally {
                    if (fileTreeElements == null) continue;
                    fileTreeElements.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read static resources", e);
            }
        }
        try {
            ClassPathUtils.consumeAsPaths(META_INF_RESOURCES, p -> this.collectKnownPaths((java.nio.file.Path)p, knownFiles));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read static resources", e);
        }
        return knownFiles.stream().filter(this::isHtmlFileName).limit(1000L).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void collectKnownPaths(final java.nio.file.Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path p, BasicFileAttributes attrs) throws IOException {
                    String file = resource.relativize(p).toString();
                    file = file.replace('\\', '/');
                    knownPaths.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm");
    }

    private static Variant selectVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        negotiation.setAcceptHeaders((List)headers.getRequestHeaders().get("Accept"));
        return negotiation.getBestMatch(VARIANTS);
    }

    public static void servlets(Map<String, List<String>> servletToMapping) {
        servletMappings = servletToMapping.values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static void staticResources(Set<String> knownRoots) {
        staticResourceRoots = new HashSet<java.nio.file.Path>();
        for (String i : knownRoots) {
            staticResourceRoots.add(Paths.get(i, new String[0]));
        }
    }

    public static void nonJaxRsClassNameToMethodPaths(Map<String, NonJaxRsClassMappings> nonJaxRsPaths) {
        nonJaxRsClassNameToMethodPaths = nonJaxRsPaths;
    }

    public static void setAdditionalEndpoints(List<AdditionalRouteDescription> additionalEndpoints) {
        NotFoundExceptionMapper.additionalEndpoints = additionalEndpoints;
    }

    public static void setReactiveRoutes(List<RouteDescription> reactiveRoutes) {
        NotFoundExceptionMapper.reactiveRoutes = reactiveRoutes;
    }

    private static class MethodDescriptionComparator
    implements Comparator<MethodDescription> {
        private MethodDescriptionComparator() {
        }

        @Override
        public int compare(MethodDescription m1, MethodDescription m2) {
            int fullPathComparison = m1.fullPath.compareTo(m2.fullPath);
            return fullPathComparison == 0 ? m1.method.compareTo(m2.method) : fullPathComparison;
        }
    }

    private static class ResourceDescriptionComparator
    implements Comparator<ResourceDescription> {
        private ResourceDescriptionComparator() {
        }

        @Override
        public int compare(ResourceDescription d1, ResourceDescription d2) {
            return d1.basePath.compareTo(d2.basePath);
        }
    }

    public static final class ResourceDescription {
        public final String basePath;
        public final List<MethodDescription> calls;

        public ResourceDescription(String basePath) {
            this.basePath = basePath;
            this.calls = new ArrayList<MethodDescription>();
        }

        public void addMethod(String path, ResourceMethodInvoker method) {
            String produces = ResourceDescription.mostPreferredOrNull(method.getProduces());
            String consumes = ResourceDescription.mostPreferredOrNull(method.getConsumes());
            for (String verb : method.getHttpMethods()) {
                this.calls.add(new MethodDescription(verb, path, produces, consumes));
            }
        }

        private static String mostPreferredOrNull(MediaType[] mediaTypes) {
            if (mediaTypes == null || mediaTypes.length < 1) {
                return null;
            }
            return mediaTypes[0].toString();
        }

        public static List<ResourceDescription> fromBoundResourceInvokers(Set<Map.Entry<String, List<ResourceInvoker>>> bound) {
            HashMap<String, ResourceDescription> descriptionMap = new HashMap<String, ResourceDescription>();
            for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
                for (ResourceInvoker invoker : entry.getValue()) {
                    if (!(invoker instanceof ResourceMethodInvoker)) continue;
                    ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
                    Class<?> resourceClass = method.getResourceClass();
                    String resourceClassName = resourceClass.getName();
                    String basePath = null;
                    NonJaxRsClassMappings nonJaxRsClassMappings = null;
                    Path path = resourceClass.getAnnotation(Path.class);
                    if (path == null) {
                        nonJaxRsClassMappings = nonJaxRsClassNameToMethodPaths.get(resourceClassName);
                        if (nonJaxRsClassMappings != null) {
                            basePath = nonJaxRsClassMappings.getBasePath();
                        }
                    } else {
                        basePath = path.value();
                    }
                    if (basePath == null) continue;
                    ResourceDescription description = (ResourceDescription)descriptionMap.get(basePath);
                    if (description == null) {
                        description = new ResourceDescription(basePath);
                        descriptionMap.put(basePath, description);
                    }
                    String subPath = "";
                    for (Annotation annotation : method.getMethodAnnotations()) {
                        if (!annotation.annotationType().equals(Path.class)) continue;
                        subPath = ((Path)annotation).value();
                        break;
                    }
                    if (subPath.isEmpty() && nonJaxRsClassMappings != null) {
                        String methodName = method.getMethod().getName();
                        String subPathFromMethodName = nonJaxRsClassMappings.getMethodNameToPath().get(methodName);
                        if (subPathFromMethodName != null) {
                            subPath = subPathFromMethodName;
                        }
                    }
                    Object fullPath = basePath;
                    if (!subPath.isEmpty()) {
                        fullPath = basePath.endsWith("/") ? (String)fullPath + subPath : basePath + (subPath.startsWith("/") ? "" : "/") + subPath;
                    }
                    description.addMethod((String)fullPath, method);
                }
            }
            ArrayList<ResourceDescription> descriptions = new ArrayList<ResourceDescription>(descriptionMap.values());
            descriptions.sort(RESOURCE_DESCRIPTION_COMPARATOR);
            for (ResourceDescription description : descriptions) {
                description.calls.sort(METHOD_DESCRIPTION_COMPARATOR);
            }
            return descriptions;
        }
    }

    public static final class MethodDescription {
        public String method;
        public String fullPath;
        public String produces;
        public String consumes;

        public MethodDescription(String method, String fullPath, String produces, String consumes) {
            this.method = method;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
        }
    }
}

