/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Execute {
    private final File esBuildExec;
    private Config config;
    private String[] args;

    public Execute(File esBuildExec, Config config) {
        this.esBuildExec = esBuildExec;
        this.config = config;
    }

    public Execute(File esBuildExec, String[] args) {
        this.esBuildExec = esBuildExec;
        this.args = args;
    }

    public void execute() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String[] command = this.args != null ? this.getCommand(this.args) : this.getCommand(this.config);
        builder.command(command);
        builder.inheritIO();
        Process process = builder.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] getCommand(Config config) {
        String[] params = config.toParams();
        return this.getCommand(params);
    }

    private String[] getCommand(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(args.length + 1);
        argList.add(this.esBuildExec.toString());
        argList.addAll(Arrays.asList(args));
        return argList.toArray(new String[0]);
    }
}

