/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageJson {
    private static final Logger logger = LoggerFactory.getLogger(PackageJson.class);
    public static final String PACKAGE_JSON = "package.json";

    public static Optional<Path> findPackageJson(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Optional.empty();
        }
        return PackageJson.findBreadthFirst(dir);
    }

    private static Optional<Path> findBreadthFirst(Path dir) {
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.add(dir);
        while (!queue.isEmpty()) {
            Path current = (Path)queue.poll();
            if (Files.isRegularFile(current.resolve(PACKAGE_JSON), new LinkOption[0])) {
                logger.debug("package.json found in {}", (Object)current);
                return Optional.of(current.resolve(PACKAGE_JSON));
            }
            try {
                Stream<Path> list = Files.list(current);
                try {
                    list.sorted().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(Predicate.not(Files::isSymbolicLink)).forEach(queue::add);
                }
                finally {
                    if (list == null) continue;
                    list.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public static String readPackageName(Path packageJson) {
        String string;
        block8: {
            InputStream packageStream = Files.newInputStream(packageJson, new OpenOption[0]);
            try {
                JSONTokener jsonTokener = new JSONTokener(packageStream);
                JSONObject object = new JSONObject(jsonTokener);
                string = object.getString("name");
                if (packageStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (packageStream != null) {
                        try {
                            packageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            packageStream.close();
        }
        return string;
    }
}

