/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class Copy {
    public static void copyEntries(Path rootDir, List<String> entries, Path targetDir) {
        for (String entry : entries) {
            try {
                Path src = rootDir.resolve(entry);
                if (!Files.exists(src, new LinkOption[0])) {
                    throw new IOException("Entry file not found: " + src);
                }
                Path dest = targetDir.resolve(entry);
                if (Files.exists(dest, new LinkOption[0])) continue;
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                Files.copy(src, dest, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(Path source) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

